/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import com.ibm.icu.text.Transliterator;
import java.io.File;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.format.BindingException;
import net.filebot.format.MediaBindingBean;
import net.filebot.media.MediaDetection;
import net.filebot.media.SmartSeasonEpisodeMatcher;
import net.filebot.media.XattrMetaInfo;
import net.filebot.similarity.CrossPropertyMetric;
import net.filebot.similarity.DateMetric;
import net.filebot.similarity.FileNameMetric;
import net.filebot.similarity.FileSizeMetric;
import net.filebot.similarity.MetricCascade;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.Normalization;
import net.filebot.similarity.NumericSimilarityMetric;
import net.filebot.similarity.SeasonEpisodeMatcher;
import net.filebot.similarity.SeasonEpisodeMetric;
import net.filebot.similarity.SequenceMatchSimilarity;
import net.filebot.similarity.SeriesNameMatcher;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.similarity.SubstringMetric;
import net.filebot.similarity.TimeStampMetric;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.vfs.FileInfo;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeFormat;
import net.filebot.web.Movie;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;

public enum EpisodeMetrics implements SimilarityMetric
{
    SeasonEpisode(new SeasonEpisodeMetric(new SmartSeasonEpisodeMatcher(null, false)){
        private final Map<Object, Collection<SeasonEpisodeMatcher.SxE>> transformCache = Collections.synchronizedMap(new HashMap(64, 4.0f));

        @Override
        protected Collection<SeasonEpisodeMatcher.SxE> parse(Object object) {
            if (object instanceof Episode) {
                Episode episode = (Episode)object;
                return this.parse(episode);
            }
            if (object instanceof Movie) {
                return Collections.emptySet();
            }
            return this.transformCache.computeIfAbsent(object, x$0 -> super.parse(x$0));
        }

        private Set<SeasonEpisodeMatcher.SxE> parse(Episode e) {
            HashSet<SeasonEpisodeMatcher.SxE> sxe = new HashSet<SeasonEpisodeMatcher.SxE>(2);
            if (e.getEpisode() != null) {
                sxe.add(new SeasonEpisodeMatcher.SxE(e.getSeason(), e.getEpisode()));
                if (e.getAbsolute() != null) {
                    sxe.add(new SeasonEpisodeMatcher.SxE(null, e.getAbsolute()));
                }
            } else if (e.getSpecial() != null) {
                sxe.add(new SeasonEpisodeMatcher.SxE(0, e.getSpecial()));
            }
            return sxe;
        }
    }),
    AirDate(new DateMetric(MediaDetection.getDateMatcher()){
        private final Map<Object, SimpleDate> transformCache = Collections.synchronizedMap(new HashMap(64, 4.0f));

        @Override
        public SimpleDate parse(Object object) {
            if (object instanceof Episode) {
                Episode episode = (Episode)object;
                return episode.getAirdate();
            }
            if (object instanceof Movie) {
                return null;
            }
            return this.transformCache.computeIfAbsent(object, x$0 -> super.parse(x$0));
        }
    }),
    Title(new SubstringMetric(){

        @Override
        protected String normalize(Object object) {
            String title;
            Episode e;
            if (object instanceof Episode && (e = (Episode)object).getTitle() != null && (title = EpisodeMetrics.normalizeObject(Normalization.removeTrailingBrackets(e.getTitle()))).length() >= 4 && !EpisodeMetrics.normalizeObject(e.getSeriesName()).contains(title)) {
                return title;
            }
            if (object instanceof Movie) {
                return EpisodeMetrics.normalizeObject(((Movie)object).getName());
            }
            String s = EpisodeMetrics.normalizeObject(object);
            return s.length() >= 4 ? s : null;
        }
    }),
    EpisodeIdentifier(new MetricCascade(SeasonEpisode, AirDate)),
    EpisodeFunnel(new MetricCascade(SeasonEpisode, AirDate, Title)),
    EpisodeBalancer(new SimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            float title;
            float sxe = EpisodeIdentifier.getSimilarity(o1, o2);
            float f = title = sxe < 1.0f ? Title.getSimilarity(o1, o2) : 1.0f;
            if (sxe < 0.0f && title == 1.0f && EpisodeIdentifier.getSimilarity(this.getTitle(o1), this.getTitle(o2)) == 1.0f) {
                sxe = 1.0f;
                title = 0.0f;
            }
            if (title == 1.0f && SeriesName.getSimilarity(o1, o2) < 0.5f) {
                title = 0.0f;
            }
            return (float)((double)(Math.max(sxe, 0.0f) * title) + Math.floor(sxe) / 10.0);
        }

        public Object getTitle(Object o) {
            if (o instanceof Episode) {
                Episode e = (Episode)o;
                return e.getSeriesName() + " " + e.getTitle();
            }
            return o;
        }
    }),
    SubstringFields(new SubstringMetric(){
        protected static final int MAX_FIELDS = 5;

        @Override
        public float getSimilarity(Object o1, Object o2) {
            String[] f1 = this.normalize(this.fields(o1));
            String[] f2 = this.normalize(this.fields(o2));
            double sum = 0.0;
            for (int i = 0; i < f1.length; ++i) {
                for (int j = 0; j < f2.length; ++j) {
                    float f = super.getSimilarity(f1[i], f2[j]);
                    if (!(f > 0.0f)) continue;
                    double multiplier = 2.0 - Math.sqrt((double)(i + j) / (double)(f1.length + f2.length));
                    sum += (double)f * multiplier;
                }
            }
            return (sum /= (double)(f1.length * f2.length)) >= 0.9 ? 1.0f : (sum >= 0.1 ? 0.5f : 0.0f);
        }

        protected String[] normalize(Object[] objects) {
            return (String[])Arrays.stream(objects).map(EpisodeMetrics::normalizeObject).toArray(String[]::new);
        }

        protected Object[] fields(Object object) {
            if (object instanceof Episode) {
                Episode e = (Episode)object;
                Stream<String> primaryNames = Stream.of(e.getSeriesName(), e.getTitle());
                Stream aliasNames = e.getSeriesInfo() == null ? Stream.empty() : e.getSeriesInfo().getAliasNames().stream().limit(5L);
                Stream<String> names = Stream.concat(primaryNames, aliasNames).filter(s -> s != null && s.length() > 0).map(Normalization::removeTrailingBrackets).distinct();
                return Arrays.copyOf(names.limit(5L).toArray(), 5);
            }
            if (object instanceof File) {
                File f = (File)object;
                return new Object[]{f, f.getParentFile().getPath()};
            }
            if (object instanceof Movie) {
                Movie m = (Movie)object;
                return new Object[]{m.getName(), m.getYear()};
            }
            return new Object[]{object};
        }
    }),
    NameSubstringSequence(new SequenceMatchSimilarity(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            String[] f1 = this.getNormalizedEffectiveIdentifiers(o1);
            String[] f2 = this.getNormalizedEffectiveIdentifiers(o2);
            float max = 0.0f;
            for (String s1 : f1) {
                for (String s2 : f2) {
                    max = Math.max(super.getSimilarity(s1, s2), max);
                }
            }
            return (float)(Math.floor(max * 4.0f) / 4.0);
        }

        @Override
        protected String normalize(Object object) {
            return object.toString();
        }

        protected String[] getNormalizedEffectiveIdentifiers(Object object) {
            List<?> identifiers = this.getEffectiveIdentifiers(object);
            String[] names = new String[identifiers.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = EpisodeMetrics.normalizeObject(identifiers.get(i));
            }
            return names;
        }

        protected List<?> getEffectiveIdentifiers(Object object) {
            if (object instanceof Episode) {
                return ((Episode)object).getSeriesNames();
            }
            if (object instanceof Movie) {
                return ((Movie)object).getEffectiveNames();
            }
            if (object instanceof File) {
                return FileUtilities.listPathTail((File)object, 3, true);
            }
            return Collections.singletonList(object);
        }
    }),
    Name(new NameSimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            return (float)(Math.floor(super.getSimilarity(o1, o2) * 4.0f) / 4.0);
        }

        @Override
        protected String normalize(Object object) {
            return EpisodeMetrics.normalizeObject(object);
        }
    }),
    SeriesName(new NameSimilarityMetric(){
        private final SeriesNameMatcher seriesNameMatcher = MediaDetection.getSeriesNameMatcher(false);

        @Override
        public float getSimilarity(Object o1, Object o2) {
            String[] f1 = this.getNormalizedEffectiveIdentifiers(o1);
            String[] f2 = this.getNormalizedEffectiveIdentifiers(o2);
            float max = 0.0f;
            for (String s1 : f1) {
                for (String s2 : f2) {
                    max = Math.max(super.getSimilarity(s1, s2), max);
                }
            }
            return (float)(Math.floor(max * 4.0f) / 4.0);
        }

        @Override
        protected String normalize(Object object) {
            return object.toString();
        }

        protected String[] getNormalizedEffectiveIdentifiers(Object object) {
            return (String[])this.getEffectiveIdentifiers(object).stream().map(EpisodeMetrics::normalizeObject).toArray(String[]::new);
        }

        protected List<?> getEffectiveIdentifiers(Object object) {
            if (object instanceof Episode) {
                Episode episode = (Episode)object;
                return MediaDetection.stripReleaseInfo(episode.getSeriesNames(), true);
            }
            if (object instanceof File) {
                File file = (File)object;
                return FileUtilities.listPathTail(file, 3, true).stream().map(f -> {
                    String fn = FileUtilities.getName(f);
                    String sn = this.seriesNameMatcher.matchByEpisodeIdentifier(fn);
                    return sn != null ? sn : fn;
                }).collect(Collectors.collectingAndThen(Collectors.toList(), v -> MediaDetection.stripReleaseInfo(v, true)));
            }
            return Collections.emptyList();
        }
    }),
    SeriesNameBalancer(new MetricCascade(NameSubstringSequence, Name, SeriesName)),
    FilePath(new NameSimilarityMetric(){

        @Override
        protected String normalize(Object object) {
            if (object instanceof File) {
                object = FileUtilities.normalizePathSeparators(FileUtilities.getRelativePathTail((File)object, 3).getPath());
            }
            return EpisodeMetrics.normalizeObject(object.toString());
        }
    }),
    FilePathBalancer(new NameSimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            String s1 = EpisodeMetrics.normalizeObject(o1);
            String s2 = EpisodeMetrics.normalizeObject(o2);
            s1 = MediaDetection.stripReleaseInfo(s1, false);
            s2 = MediaDetection.stripReleaseInfo(s2, false);
            int length = Math.min(s1.length(), s2.length());
            s1 = s1.substring(0, length);
            s2 = s2.substring(0, length);
            return (float)(Math.floor(super.getSimilarity(s1, s2) * 4.0f) / 4.0);
        }

        @Override
        protected String normalize(Object object) {
            return object.toString();
        }
    }),
    NumericSequence(new SequenceMatchSimilarity(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            float lowerBound = super.getSimilarity(this.normalize(o1, true), this.normalize(o2, true));
            float upperBound = super.getSimilarity(this.normalize(o1, false), this.normalize(o2, false));
            return Math.max(lowerBound, upperBound);
        }

        @Override
        protected String normalize(Object object) {
            return object.toString();
        }

        protected String normalize(Object object, boolean numbersOnly) {
            if (object instanceof Episode) {
                Episode e = (Episode)object;
                object = numbersOnly ? EpisodeFormat.SeasonEpisode.formatSxE(e) : String.format("%s %s", e.getSeriesName(), EpisodeFormat.SeasonEpisode.formatSxE(e));
            } else if (object instanceof Movie) {
                Movie m = (Movie)object;
                object = numbersOnly ? Integer.valueOf(m.getYear()) : String.format("%s %s", m.getName(), m.getYear());
            }
            List<Integer> numbers = StringUtilities.matchIntegers(EpisodeMetrics.normalizeObject(object));
            return StringUtilities.join(numbers, (CharSequence)" ");
        }
    }),
    Numeric(new NumericSimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            String[] f1 = this.fields(o1);
            String[] f2 = this.fields(o2);
            float max = 0.0f;
            for (String s1 : f1) {
                for (String s2 : f2) {
                    if (s1 == null || s2 == null || !((max = Math.max(super.getSimilarity(s1, s2), max)) >= 1.0f)) continue;
                    return max;
                }
            }
            return max;
        }

        protected String[] fields(Object object) {
            if (object instanceof Episode) {
                Episode episode = (Episode)object;
                String[] f = new String[]{episode.getSeriesName(), episode.getSpecial() == null ? EpisodeFormat.SeasonEpisode.formatSxE(episode) : episode.getSpecial().toString(), episode.getAbsolute() == null ? null : episode.getAbsolute().toString()};
                return f;
            }
            if (object instanceof Movie) {
                Movie movie = (Movie)object;
                return new String[]{movie.getName(), String.valueOf(movie.getYear())};
            }
            return new String[]{EpisodeMetrics.normalizeObject(object)};
        }
    }),
    SpecialNumber(new SimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            return this.getSpecialFactor(o1) + this.getSpecialFactor(o2);
        }

        public int getSpecialFactor(Object object) {
            if (object instanceof Episode) {
                Episode episode = (Episode)object;
                return episode.getSpecial() != null ? -1 : 1;
            }
            return 0;
        }
    }),
    FileSize(new FileSizeMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            return o1 instanceof File ? super.getSimilarity(o2, o1) : super.getSimilarity(o1, o2);
        }

        @Override
        protected long getLength(Object object) {
            if (object instanceof FileInfo) {
                return ((FileInfo)object).getLength();
            }
            return super.getLength(object);
        }
    }),
    FileName(new FileNameMetric(){

        @Override
        protected String getFileName(Object object) {
            if (object instanceof File || object instanceof FileInfo) {
                return EpisodeMetrics.normalizeObject(object);
            }
            return null;
        }
    }),
    TimeStamp(new TimeStampMetric(10, ChronoUnit.YEARS){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            float f = super.getSimilarity(o1, o2);
            return (double)f >= 0.75 ? 1.0f : (f >= 0.0f ? 0.0f : -1.0f);
        }

        private long getTimeStamp(SimpleDate date) {
            Instant t;
            if (date != null && (t = date.toInstant()).isBefore(Instant.now())) {
                return t.toEpochMilli();
            }
            return -1L;
        }

        private long getTimeStamp(File file) {
            if (MediaTypes.VIDEO_FILES.accept(file) && file.length() > 1000000L) {
                try {
                    return new MediaBindingBean(file, file).getEncodedDate().getTimeStamp();
                }
                catch (BindingException e) {
                    Logging.debug.finest(e::getMessage);
                }
                catch (Exception e) {
                    Logging.debug.warning("Failed to read media encoding date: " + e.getMessage());
                }
            }
            return super.getTimeStamp(file);
        }

        @Override
        public long getTimeStamp(Object object) {
            if (object instanceof Episode) {
                Episode e = (Episode)object;
                return this.getTimeStamp(e.getAirdate());
            }
            if (object instanceof Movie) {
                Movie m = (Movie)object;
                return this.getTimeStamp(new SimpleDate(m.getYear(), 1, 1));
            }
            if (object instanceof File) {
                File file = (File)object;
                return this.getTimeStamp(file);
            }
            return -1L;
        }
    }),
    SeriesRating(new SimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            float r1 = this.getScore(o1);
            float r2 = this.getScore(o2);
            if (r1 < 0.0f || r2 < 0.0f) {
                return -1.0f;
            }
            return Math.max(r1, r2);
        }

        public float getScore(Object object) {
            SeriesInfo seriesInfo;
            if (object instanceof Episode && (seriesInfo = ((Episode)object).getSeriesInfo()) != null && seriesInfo.getRating() != null && seriesInfo.getRatingCount() != null) {
                if (seriesInfo.getRatingCount() >= 20) {
                    return (float)Math.floor(seriesInfo.getRating() / 3.0);
                }
                if (seriesInfo.getRatingCount() >= 1) {
                    return 0.0f;
                }
                return -1.0f;
            }
            return 0.0f;
        }
    }),
    VoteRate(new SimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            float r2;
            float r1 = this.getScore(o1);
            return (double)Math.max(r1, r2 = this.getScore(o2)) >= 0.1 ? 1.0f : 0.0f;
        }

        public float getScore(Object object) {
            long days;
            SeriesInfo seriesInfo;
            if (object instanceof Episode && (seriesInfo = ((Episode)object).getSeriesInfo()) != null && seriesInfo.getRating() != null && seriesInfo.getRatingCount() != null && seriesInfo.getStartDate() != null && (days = ChronoUnit.DAYS.between(seriesInfo.getStartDate().toLocalDate(), LocalDate.now())) > 0L) {
                return (float)(seriesInfo.getRatingCount().doubleValue() / (double)days * seriesInfo.getRating());
            }
            return 0.0f;
        }
    }),
    RegionHint(new SimilarityMetric(){
        private final Pattern hint = Pattern.compile("[(](\\p{Alpha}+|\\p{Digit}+)[)]$");
        private final SeriesNameMatcher seriesNameMatcher = MediaDetection.getSeriesNameMatcher(true);

        @Override
        public float getSimilarity(Object o1, Object o2) {
            Set<String> h1 = this.getHint(o1);
            Set<String> h2 = this.getHint(o2);
            return h1.isEmpty() || h2.isEmpty() ? 0.0f : (h1.containsAll(h2) || h2.containsAll(h1) ? 1.0f : 0.0f);
        }

        public Set<String> getHint(Object o) {
            if (o instanceof Episode) {
                for (String sn : ((Episode)o).getSeriesNames()) {
                    Matcher m = this.hint.matcher(sn);
                    if (!m.find()) continue;
                    return Collections.singleton(m.group(1).trim().toLowerCase());
                }
            } else if (o instanceof File) {
                HashSet<String> h = new HashSet<String>();
                for (File f : FileUtilities.listPathTail((File)o, 3, true)) {
                    String[] tokens;
                    String fn = f.getName();
                    String sn = this.seriesNameMatcher.matchByEpisodeIdentifier(fn);
                    for (String s : tokens = Normalization.PUNCTUATION_OR_SPACE.split(sn != null ? sn : fn)) {
                        if (s.length() <= 0) continue;
                        h.add(s.trim().toLowerCase());
                    }
                }
                return h;
            }
            return Collections.emptySet();
        }
    }),
    MetaAttributes(new CrossPropertyMetric(){

        @Override
        protected Map<String, Object> getProperties(Object object) {
            Object metaObject;
            if (object instanceof Episode || object instanceof Movie) {
                return super.getProperties(object);
            }
            if (object instanceof File && (metaObject = XattrMetaInfo.xattr.getMetaInfo((File)object)) != null) {
                return super.getProperties(metaObject);
            }
            return Collections.emptyMap();
        }
    });

    private final SimilarityMetric metric;
    private static final Map<Object, String> transformCache;
    private static final Transliterator transliterator;

    private EpisodeMetrics(SimilarityMetric metric) {
        this.metric = metric;
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        return this.metric.getSimilarity(o1, o2);
    }

    public static String normalizeObject(Object object) {
        if (object == null) {
            return "";
        }
        return transformCache.computeIfAbsent(object, o -> {
            String name = EpisodeMetrics.normalizeFileName(o);
            name = Normalization.removeEmbeddedChecksum(name);
            name = MediaDetection.stripFormatInfo(name);
            Transliterator transliterator = transliterator;
            synchronized (transliterator) {
                name = transliterator.transform(name);
            }
            return Normalization.normalizePunctuation(name).toLowerCase();
        });
    }

    private static String normalizeFileName(Object object) {
        if (object instanceof File) {
            return FileUtilities.getName((File)object);
        }
        if (object instanceof FileInfo) {
            return ((FileInfo)object).getName();
        }
        return object.toString();
    }

    public static SimilarityMetric[] defaultSequence(boolean includeFileMetrics) {
        if (includeFileMetrics) {
            return new SimilarityMetric[]{FileSize, new MetricCascade(FileName, EpisodeFunnel), EpisodeBalancer, AirDate, MetaAttributes, SubstringFields, SeriesNameBalancer, SeriesName, RegionHint, SpecialNumber, Numeric, NumericSequence, SeriesRating, VoteRate, TimeStamp, FilePathBalancer, FilePath};
        }
        return new SimilarityMetric[]{EpisodeFunnel, EpisodeBalancer, AirDate, MetaAttributes, SubstringFields, SeriesNameBalancer, SeriesName, RegionHint, SpecialNumber, Numeric, NumericSequence, SeriesRating, VoteRate, TimeStamp, FilePathBalancer, FilePath};
    }

    public static SimilarityMetric verificationMetric() {
        return new MetricCascade(FileName, SeasonEpisode, AirDate, Title, Name);
    }

    static {
        transformCache = Collections.synchronizedMap(new HashMap(64, 4.0f));
        transliterator = Transliterator.getInstance("Any-Latin;Latin-ASCII;[:Diacritic:]remove");
    }
}

