/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.similarity;

import java.io.File;
import java.util.Collection;
import net.filebot.similarity.SeasonEpisodeMatcher;
import net.filebot.similarity.SimilarityMetric;

public class SeasonEpisodeMetric
implements SimilarityMetric {
    private SeasonEpisodeMatcher seasonEpisodeMatcher;

    public SeasonEpisodeMetric() {
        this.seasonEpisodeMatcher = new SeasonEpisodeMatcher(null, false);
    }

    public SeasonEpisodeMetric(SeasonEpisodeMatcher seasonEpisodeMatcher) {
        this.seasonEpisodeMatcher = seasonEpisodeMatcher;
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        Collection<SeasonEpisodeMatcher.SxE> sxeVector1 = this.parse(o1);
        if (sxeVector1 == null || sxeVector1.isEmpty()) {
            return 0.0f;
        }
        Collection<SeasonEpisodeMatcher.SxE> sxeVector2 = this.parse(o2);
        if (sxeVector2 == null || sxeVector2.isEmpty()) {
            return 0.0f;
        }
        float similarity = -1.0f;
        for (SeasonEpisodeMatcher.SxE sxe1 : sxeVector1) {
            for (SeasonEpisodeMatcher.SxE sxe2 : sxeVector2) {
                if (sxe1.season == sxe2.season && sxe1.episode == sxe2.episode && sxe1.season >= 0 && sxe2.season >= 0) {
                    return 1.0f;
                }
                if ((sxe1.season < 0 || sxe1.season != sxe2.season) && (sxe1.episode < 0 || sxe1.episode != sxe2.episode)) continue;
                similarity = 0.5f;
            }
        }
        return similarity;
    }

    protected Collection<SeasonEpisodeMatcher.SxE> parse(Object object) {
        if (object instanceof File) {
            return this.seasonEpisodeMatcher.match((File)object);
        }
        return this.seasonEpisodeMatcher.match(object.toString());
    }
}

