/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.similarity.Normalization;
import net.filebot.subtitle.SubtitleDecoder;
import net.filebot.subtitle.SubtitleElement;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class SamiDecoder
implements SubtitleDecoder {
    @Override
    public Stream<SubtitleElement> decode(String file) {
        ArrayList<SubtitleElement> subtitles = new ArrayList<SubtitleElement>();
        Matcher matcher = Pattern.compile("<SYNC(.*?)>", 2).matcher(file);
        long previousSyncStart = -1L;
        long previousSyncEnd = -1L;
        int previousSequenceEnd = -1;
        while (matcher.find()) {
            Element sync = Jsoup.parseBodyFragment(matcher.group()).select("sync").first();
            long nextSyncStart = this.getLongAttribute(sync, "start");
            long nextSyncEnd = this.getLongAttribute(sync, "end");
            if (previousSequenceEnd > 0) {
                SubtitleElement subtitle;
                if (previousSyncEnd < 0L) {
                    previousSyncEnd = nextSyncStart;
                }
                if ((subtitle = this.getSubtitle(previousSyncStart, previousSyncEnd, file.subSequence(previousSequenceEnd, matcher.start()))) != null) {
                    subtitles.add(subtitle);
                }
            }
            if (nextSyncStart < 0L) continue;
            previousSyncStart = nextSyncStart;
            previousSyncEnd = nextSyncEnd;
            previousSequenceEnd = matcher.end();
        }
        if (previousSequenceEnd > 0) {
            SubtitleElement subtitle;
            if (previousSyncEnd < 0L) {
                previousSyncEnd = previousSyncStart + 2000L;
            }
            if ((subtitle = this.getSubtitle(previousSyncStart, previousSyncEnd, file.subSequence(previousSequenceEnd, file.length()))) != null) {
                subtitles.add(subtitle);
            }
        }
        return subtitles.stream();
    }

    private SubtitleElement getSubtitle(long start, long end, CharSequence fragment) {
        Document document;
        String text;
        if (start >= 0L && end >= 0L && (text = (document = Jsoup.parseBodyFragment(fragment.toString())).select("p").stream().map(p -> p.text()).map(s -> Normalization.replaceSpace(s, " ")).filter(s -> s.length() > 0).collect(Collectors.joining("\n")).trim()).length() > 0) {
            return new SubtitleElement(start, end, text);
        }
        return null;
    }

    private long getLongAttribute(Element node, String key) {
        String value;
        if (node != null && (value = node.attr(key)).length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                Logging.debug.warning(Logging.cause(e));
            }
        }
        return -1L;
    }
}

