/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.filebot.subtitle.SubtitleElement;
import net.filebot.subtitle.SubtitleReader;
import net.filebot.subtitle.SubtitleTimeFormat;

public class SubStationAlphaReader
extends SubtitleReader {
    private final DateFormat timeFormat = new SubtitleTimeFormat();
    private final Pattern newline = Pattern.compile(Pattern.quote("\\n"), 2);
    private final Pattern tags = Pattern.compile("[{]\\\\[^}]+[}]");
    private final Pattern drawingTags = Pattern.compile("\\\\[p][0-4]");
    private String[] format;
    private int formatIndexStart;
    private int formatIndexEnd;
    private int formatIndexText;

    public SubStationAlphaReader(Scanner scanner) {
        super(scanner);
    }

    private void readFormat() throws Exception {
        String line = this.scanner.nextLine();
        String[] event = line.split(":", 2);
        if (!event[0].equals("Format")) {
            throw new InputMismatchException("Illegal format header: " + line);
        }
        this.format = event[1].split(",");
        for (int i = 0; i < this.format.length; ++i) {
            this.format[i] = this.format[i].trim().toLowerCase();
        }
        List<String> lookup = Arrays.asList(this.format);
        this.formatIndexStart = lookup.indexOf("start");
        this.formatIndexEnd = lookup.indexOf("end");
        this.formatIndexText = lookup.indexOf("text");
    }

    @Override
    public SubtitleElement readNext() throws Exception {
        String[] event;
        if (this.format == null) {
            boolean found = false;
            while (!found && this.scanner.hasNextLine()) {
                found = this.scanner.nextLine().equals("[Events]");
            }
            if (!found) {
                throw new InputMismatchException("Cannot find [Events] section");
            }
            this.readFormat();
        }
        if ((event = this.scanner.nextLine().split(":", 2)).length < 2 || !event[0].equals("Dialogue")) {
            return null;
        }
        String[] values = event[1].split(",", this.format.length);
        long start = this.timeFormat.parse(values[this.formatIndexStart].trim()).getTime();
        long end = this.timeFormat.parse(values[this.formatIndexEnd].trim()).getTime();
        String text = values[this.formatIndexText].trim();
        if (this.drawingTags.matcher(text).find()) {
            return null;
        }
        return new SubtitleElement(start, end, this.resolve(text));
    }

    protected String resolve(String text) {
        text = this.tags.matcher(text).replaceAll("");
        return this.newline.matcher(text).replaceAll("\n");
    }
}

