/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.InputMismatchException;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.filebot.subtitle.SubtitleElement;
import net.filebot.subtitle.SubtitleReader;
import net.filebot.subtitle.SubtitleTimeFormat;
import net.filebot.util.StringUtilities;

public class SubViewerReader
extends SubtitleReader {
    private final DateFormat timeFormat = new SubtitleTimeFormat();
    private final Pattern newline = Pattern.compile(Pattern.quote("[br]"), 2);

    public SubViewerReader(Scanner scanner) {
        super(scanner);
    }

    @Override
    protected SubtitleElement readNext() throws Exception {
        String[] interval = this.scanner.nextLine().split(",", 2);
        if (interval.length < 2 || interval[0].startsWith("[")) {
            return null;
        }
        try {
            long t1 = this.timeFormat.parse(interval[0]).getTime();
            long t2 = this.timeFormat.parse(interval[1]).getTime();
            Object[] lines = this.newline.split(this.scanner.nextLine());
            return new SubtitleElement(t1, t2, StringUtilities.join(lines, (CharSequence)"\n"));
        }
        catch (ParseException e) {
            return null;
        }
        catch (InputMismatchException e) {
            return null;
        }
    }
}

