/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.filebot.Logging;
import net.filebot.media.MediaDetection;
import net.filebot.media.XattrMetaInfo;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.similarity.CrossPropertyMetric;
import net.filebot.similarity.EpisodeMetrics;
import net.filebot.similarity.MetricAvg;
import net.filebot.similarity.MetricCascade;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.NumericSimilarityMetric;
import net.filebot.similarity.SequenceMatchSimilarity;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.util.FileUtilities;
import net.filebot.web.OpenSubtitlesSubtitleDescriptor;
import net.filebot.web.SubtitleDescriptor;

public enum SubtitleMetrics implements SimilarityMetric
{
    AbsoluteSeasonEpisode(new SimilarityMetric(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            float f = EpisodeMetrics.SeasonEpisode.getSimilarity(o1, o2);
            if (f == 0.0f && MediaDetection.getEpisodeIdentifier(o1.toString(), true) == null == (MediaDetection.getEpisodeIdentifier(o2.toString(), true) == null)) {
                return 0.0f;
            }
            return f < 1.0f ? -1.0f : 1.0f;
        }
    }),
    DiskNumber(new NumericSimilarityMetric(){
        private final Pattern CDNO = Pattern.compile("(?:CD|DISK)(\\d+)", 2);

        @Override
        public float getSimilarity(Object o1, Object o2) {
            int c1 = this.getDiskNumber(o1);
            int c2 = this.getDiskNumber(o2);
            if (c1 == 0 && c2 == 0) {
                return 0.0f;
            }
            return c1 == c2 ? 1.0f : -1.0f;
        }

        public int getDiskNumber(Object o) {
            int cd = 0;
            Matcher matcher = this.CDNO.matcher(o.toString());
            while (matcher.find()) {
                cd = Integer.parseInt(matcher.group(1));
            }
            return cd;
        }
    }),
    NameSubstringSequenceExists(new SequenceMatchSimilarity(){

        @Override
        public float getSimilarity(Object o1, Object o2) {
            String[] f1 = this.getNormalizedEffectiveIdentifiers(o1);
            String[] f2 = this.getNormalizedEffectiveIdentifiers(o2);
            for (String s1 : f1) {
                for (String s2 : f2) {
                    if (!(super.getSimilarity(s1, s2) >= 1.0f)) continue;
                    return 1.0f;
                }
            }
            return 0.0f;
        }

        @Override
        protected float similarity(String match, String s1, String s2) {
            return match.length() > 0 ? 1.0f : 0.0f;
        }

        @Override
        protected String normalize(Object object) {
            return object.toString();
        }

        protected String[] getNormalizedEffectiveIdentifiers(Object object) {
            List<?> identifiers = this.getEffectiveIdentifiers(object);
            String[] names = new String[identifiers.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = EpisodeMetrics.normalizeObject(identifiers.get(i));
            }
            return names;
        }

        protected List<?> getEffectiveIdentifiers(Object object) {
            if (object instanceof OpenSubtitlesSubtitleDescriptor) {
                return Collections.singletonList(((OpenSubtitlesSubtitleDescriptor)object).getName());
            }
            if (object instanceof File) {
                return FileUtilities.listPathTail((File)object, 2, true);
            }
            return Collections.emptyList();
        }
    }),
    OriginalFileName(new SequenceMatchSimilarity(){

        @Override
        protected float similarity(String match, String s1, String s2) {
            return (double)((float)match.length() / (float)Math.max(s1.length(), s2.length())) > 0.8 ? 1.0f : 0.0f;
        }

        @Override
        public String normalize(Object object) {
            if (object instanceof File) {
                File file = (File)object;
                String name = XattrMetaInfo.xattr.getOriginalName(file);
                if (name == null) {
                    name = file.getName();
                }
                return super.normalize(FileUtilities.getNameWithoutExtension(name));
            }
            if (object instanceof OpenSubtitlesSubtitleDescriptor) {
                String name = ((OpenSubtitlesSubtitleDescriptor)object).getName();
                return super.normalize(name);
            }
            return super.normalize(object);
        }
    }),
    VideoProperties(new CrossPropertyMetric(){
        private final String FPS = "FPS";
        private final String SECONDS = "SECS";
        private final Map<File, Map<String, Object>> mediaInfoCache = Collections.synchronizedMap(new WeakHashMap(64));

        @Override
        public float getSimilarity(Object o1, Object o2) {
            return o1 instanceof SubtitleDescriptor ? super.getSimilarity(o1, o2) : super.getSimilarity(o2, o1);
        }

        @Override
        protected Map<String, Object> getProperties(Object object) {
            if (object instanceof OpenSubtitlesSubtitleDescriptor) {
                return this.getSubtitleProperties((OpenSubtitlesSubtitleDescriptor)object);
            }
            if (object instanceof File) {
                return this.getVideoProperties((File)object);
            }
            return Collections.emptyMap();
        }

        private Map<String, Object> getProperties(float fps, long millis) {
            HashMap<String, Object> props = new HashMap<String, Object>(2);
            if (fps > 0.0f) {
                props.put("FPS", Math.round(fps));
            }
            if (millis > 0L) {
                props.put("SECS", Math.round(Math.floor((double)millis / 1000.0)));
            }
            return props;
        }

        private Map<String, Object> getSubtitleProperties(OpenSubtitlesSubtitleDescriptor subtitle) {
            try {
                return this.getProperties(subtitle.getMovieFPS(), subtitle.getMovieTimeMS());
            }
            catch (Exception e) {
                Logging.debug.warning("Failed to read subtitle properties: " + e);
                return Collections.emptyMap();
            }
        }

        private Map<String, Object> getVideoProperties(File file) {
            return this.mediaInfoCache.computeIfAbsent(file, key -> {
                try (MediaInfo mi = new MediaInfo().open(file);){
                    float fps = Float.parseFloat(mi.get(MediaInfo.StreamKind.Video, 0, "FrameRate"));
                    long millis = Long.parseLong(mi.get(MediaInfo.StreamKind.Video, 0, "Duration"));
                    Map<String, Object> map = this.getProperties(fps, millis);
                    return map;
                }
                catch (Exception e) {
                    Logging.debug.warning("Failed to read video properties: " + e.getMessage());
                    return Collections.emptyMap();
                }
            });
        }
    });

    private final SimilarityMetric metric;

    private SubtitleMetrics(SimilarityMetric metric) {
        this.metric = metric;
    }

    @Override
    public float getSimilarity(Object o1, Object o2) {
        return this.metric.getSimilarity(o1, o2);
    }

    public static SimilarityMetric[] defaultSequence() {
        return new SimilarityMetric[]{EpisodeMetrics.EpisodeFunnel, EpisodeMetrics.EpisodeBalancer, OriginalFileName, NameSubstringSequenceExists, new MetricAvg(NameSubstringSequenceExists, EpisodeMetrics.Name), EpisodeMetrics.Numeric, EpisodeMetrics.FileName, DiskNumber, VideoProperties, new NameSimilarityMetric()};
    }

    public static SimilarityMetric verificationMetric() {
        return new MetricCascade(AbsoluteSeasonEpisode, EpisodeMetrics.AirDate, new MetricAvg(NameSubstringSequenceExists, EpisodeMetrics.Name), MediaDetection.getMovieMatchMetric(), OriginalFileName);
    }
}

