/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.filebot.Logging;
import net.filebot.subtitle.SubtitleElement;

public abstract class SubtitleReader
implements Iterator<SubtitleElement>,
Closeable {
    protected Scanner scanner;
    protected SubtitleElement current;

    public SubtitleReader(Scanner scanner) {
        this.scanner = scanner;
    }

    protected abstract SubtitleElement readNext() throws Exception;

    @Override
    public boolean hasNext() {
        while (this.current == null && this.scanner.hasNextLine()) {
            try {
                this.current = this.readNext();
            }
            catch (Exception e) {
                Logging.debug.finest(Logging.cause(e));
            }
        }
        return this.current != null;
    }

    @Override
    public SubtitleElement next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            SubtitleElement subtitleElement = this.current;
            return subtitleElement;
        }
        finally {
            this.current = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    public Stream<SubtitleElement> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
    }
}

