/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.subtitle;

import com.optimaize.langdetect.DetectedLanguage;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.BuiltInLanguages;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Language;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.media.MediaDetection;
import net.filebot.similarity.Match;
import net.filebot.similarity.Matcher;
import net.filebot.similarity.MetricAvg;
import net.filebot.similarity.NameSimilarityMetric;
import net.filebot.similarity.Normalization;
import net.filebot.similarity.SeasonEpisodeMatcher;
import net.filebot.similarity.SequenceMatchSimilarity;
import net.filebot.similarity.SimilarityComparator;
import net.filebot.similarity.SimilarityMetric;
import net.filebot.subtitle.SubRipWriter;
import net.filebot.subtitle.SubtitleElement;
import net.filebot.subtitle.SubtitleFormat;
import net.filebot.subtitle.SubtitleMetrics;
import net.filebot.util.ByteBufferInputStream;
import net.filebot.util.ByteBufferOutputStream;
import net.filebot.util.FileUtilities;
import net.filebot.vfs.ArchiveType;
import net.filebot.vfs.MemoryFile;
import net.filebot.web.SubtitleDescriptor;
import net.filebot.web.SubtitleProvider;
import net.filebot.web.SubtitleSearchResult;
import net.filebot.web.VideoHashSubtitleService;
import org.apache.commons.io.IOUtils;

public final class SubtitleUtilities {
    private static LanguageDetectorBuilder languageDetector;

    public static Map<File, List<SubtitleDescriptor>> lookupSubtitlesByHash(VideoHashSubtitleService service, Collection<File> files, Locale locale, boolean addOptions, boolean strict) throws Exception {
        Map<File, List<SubtitleDescriptor>> options = service.getSubtitleList(files.toArray(new File[files.size()]), locale);
        LinkedHashMap<File, List<SubtitleDescriptor>> results = new LinkedHashMap<File, List<SubtitleDescriptor>>(options.size());
        options.forEach((k, v) -> {
            SubtitleDescriptor bestMatch = SubtitleUtilities.getBestMatch(k, v, strict);
            if (bestMatch != null) {
                if (addOptions) {
                    Stream<SubtitleDescriptor> top1 = Stream.of(bestMatch);
                    Stream topN = v.stream().filter(Predicate.isEqual(bestMatch).negate()).sorted(SimilarityComparator.compareTo(FileUtilities.getName(k), SubtitleDescriptor::getName));
                    results.put((File)k, Stream.concat(top1, topN).collect(Collectors.toList()));
                } else {
                    results.put((File)k, Collections.singletonList(bestMatch));
                }
            }
        });
        return results;
    }

    /*
     * Exception decompiling
     */
    public static Map<File, List<SubtitleDescriptor>> findSubtitlesByName(SubtitleProvider service, Collection<File> fileSet, Locale locale, String forceQuery, boolean addOptions, boolean strict) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<File, SubtitleDescriptor> matchSubtitles(Collection<File> files, Collection<SubtitleDescriptor> subtitles) throws InterruptedException {
        LinkedHashMap<File, SubtitleDescriptor> subtitleByVideo = new LinkedHashMap<File, SubtitleDescriptor>();
        SimilarityMetric[] metrics = SubtitleMetrics.defaultSequence();
        Matcher<File, SubtitleDescriptor> matcher = new Matcher<File, SubtitleDescriptor>(files, subtitles, false, metrics);
        for (Match<File, SubtitleDescriptor> it : matcher.match()) {
            subtitleByVideo.put(it.getValue(), it.getCandidate());
        }
        return subtitleByVideo;
    }

    protected static List<SubtitleSearchResult> findProbableSearchResults(SubtitleProvider service, Collection<String> querySet, boolean searchByMovie, boolean searchBySeries) throws Exception {
        ArrayList<SubtitleSearchResult> resultSet = new ArrayList<SubtitleSearchResult>();
        for (String query : querySet) {
            Stream<SubtitleSearchResult> searchResults = service.search(query).stream().filter(it -> searchByMovie && it.isMovie() || searchBySeries && it.isSeries());
            resultSet.addAll(SubtitleUtilities.filterProbableSearchResults(query, searchResults::iterator, querySet.size() == 1 ? 4 : 2));
        }
        return resultSet;
    }

    protected static List<SubtitleSearchResult> filterProbableSearchResults(String query, Iterable<SubtitleSearchResult> searchResults, int limit) {
        ArrayList<SubtitleSearchResult> probableMatches = new ArrayList<SubtitleSearchResult>();
        MetricAvg metric = new MetricAvg(new SequenceMatchSimilarity(), new NameSimilarityMetric());
        block0: for (SubtitleSearchResult result : searchResults) {
            if (probableMatches.size() > limit) continue;
            for (String name : result.getEffectiveNames()) {
                if (!(metric.getSimilarity(query, Normalization.removeTrailingBrackets(name)) > 0.8f) && !name.toLowerCase().startsWith(query.toLowerCase())) continue;
                probableMatches.add(result);
                continue block0;
            }
        }
        return probableMatches;
    }

    public static SubtitleDescriptor getBestMatch(File file, Collection<SubtitleDescriptor> subtitles, boolean strict) {
        if (file == null || subtitles == null || subtitles.isEmpty()) {
            return null;
        }
        try {
            SimilarityMetric sanity = SubtitleMetrics.verificationMetric();
            float minMatchSimilarity = strict ? 0.8f : 0.2f;
            for (Map.Entry<File, SubtitleDescriptor> it : SubtitleUtilities.matchSubtitles(Collections.singleton(file), subtitles).entrySet()) {
                if (!(sanity.getSimilarity(it.getKey(), it.getValue()) >= minMatchSimilarity)) continue;
                return it.getValue();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<SubtitleElement> decodeSubtitles(MemoryFile file) throws IOException {
        LinkedList<SubtitleFormat> likelyFormats = new LinkedList<SubtitleFormat>();
        for (SubtitleFormat format : SubtitleFormat.values()) {
            if (format.getFilter().accept(file.getName())) {
                likelyFormats.addFirst(format);
                continue;
            }
            likelyFormats.addLast(format);
        }
        Reader reader = FileUtilities.createTextReader(new ByteBufferInputStream(file.getData()), true, StandardCharsets.UTF_8);
        String content = IOUtils.toString(reader);
        for (SubtitleFormat format : likelyFormats) {
            List<SubtitleElement> subtitles = format.getDecoder().decode(content).collect(Collectors.toList());
            if (subtitles.size() <= 0) continue;
            return subtitles;
        }
        throw new IOException("Subtitle format not supported");
    }

    public static ByteBuffer exportSubtitles(MemoryFile file, SubtitleFormat outputFormat, long outputTimingOffset, Charset outputEncoding) throws IOException {
        if (outputFormat != null && outputFormat != SubtitleFormat.SubRip) {
            throw new IllegalArgumentException("Format not supported");
        }
        ByteBufferOutputStream buffer = new ByteBufferOutputStream(file.size());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buffer, outputEncoding);
        if (outputFormat == SubtitleFormat.SubRip) {
            try (SubRipWriter out = new SubRipWriter(writer);){
                for (SubtitleElement it : SubtitleUtilities.decodeSubtitles(file)) {
                    if (it.isEmpty()) {
                        Logging.debug.warning(Logging.message("Subtitle element is empty", it));
                        continue;
                    }
                    if (outputTimingOffset != 0L) {
                        it = new SubtitleElement(Math.max(0L, it.getStart() + outputTimingOffset), Math.max(0L, it.getEnd() + outputTimingOffset), it.getText());
                    }
                    out.write(it);
                }
            }
        } else {
            Reader reader = FileUtilities.createTextReader(new ByteBufferInputStream(file.getData()), true, StandardCharsets.UTF_8);
            IOUtils.copy(reader, (Writer)writer);
        }
        return buffer.getByteBuffer();
    }

    public static SubtitleFormat getSubtitleFormat(File file) {
        for (SubtitleFormat it : SubtitleFormat.values()) {
            if (!it.getFilter().accept(file)) continue;
            return it;
        }
        return null;
    }

    public static SubtitleFormat getSubtitleFormatByName(String name) {
        for (SubtitleFormat it : SubtitleFormat.values()) {
            if (it.name().equalsIgnoreCase(name)) {
                return it;
            }
            if (!it.getFilter().acceptExtension(name)) continue;
            return it;
        }
        return null;
    }

    public static String formatSubtitle(String name, String languageName, String type) {
        StringBuilder sb = new StringBuilder(name);
        if (languageName != null) {
            String lang = Language.getStandardLanguageCode(languageName);
            if (lang == null) {
                lang = languageName.replaceAll("\\W", "");
            }
            sb.append('.').append(lang);
        }
        if (type != null) {
            sb.append('.').append(type);
        }
        return sb.toString();
    }

    public static MemoryFile fetchSubtitle(SubtitleDescriptor descriptor) throws Exception {
        ByteBuffer data = descriptor.fetch();
        ArchiveType type = ArchiveType.forName(descriptor.getType());
        if (type != ArchiveType.UNKOWN) {
            for (MemoryFile entry : type.fromData(data)) {
                if (!MediaTypes.SUBTITLE_FILES.accept(entry.getName())) continue;
                return entry;
            }
        }
        return new MemoryFile(descriptor.getPath(), data);
    }

    public static Language detectSubtitleLanguage(File file) throws IOException {
        Locale languageTag = MediaDetection.releaseInfo.getSubtitleLanguageTag(FileUtilities.getName(file));
        if (languageTag != null) {
            return Language.getLanguage(languageTag);
        }
        Language languageName = Language.findLanguage(FileUtilities.getName(file));
        if (languageName != null) {
            return languageName;
        }
        MemoryFile data = new MemoryFile(file.getName(), ByteBuffer.wrap(FileUtilities.readFile(file)));
        List<DetectedLanguage> options = SubtitleUtilities.detectSubtitleLanguage(data);
        if (options.size() > 0) {
            return Language.getLanguage(options.get(0).getLocale().getLanguage());
        }
        return null;
    }

    public static List<DetectedLanguage> detectSubtitleLanguage(MemoryFile file) throws IOException {
        String text = SubtitleUtilities.decodeSubtitles(file).stream().map(SubtitleElement::getText).collect(Collectors.joining("\n"));
        return SubtitleUtilities.createLanguageDetector().getProbabilities(text);
    }

    private static LanguageDetector createLanguageDetector() throws IOException {
        if (languageDetector == null) {
            List<LdLocale> languages = BuiltInLanguages.getLanguages().stream().filter(lc -> Language.getLanguage(lc.getLanguage()) != null).collect(Collectors.toList());
            List<LanguageProfile> languageProfiles = new LanguageProfileReader().readBuiltIn(languages);
            languageDetector = LanguageDetectorBuilder.create(NgramExtractors.standard()).withProfiles(languageProfiles);
        }
        return languageDetector.build();
    }

    private SubtitleUtilities() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ int[][] lambda$findSubtitlesByName$7(int x$0) {
        return new int[x$0][];
    }

    private static /* synthetic */ int[] lambda$findSubtitlesByName$6(SeasonEpisodeMatcher.SxE sxe) {
        return new int[]{sxe.season, -1};
    }

    private static /* synthetic */ int[][] lambda$findSubtitlesByName$5(int x$0) {
        return new int[x$0][];
    }
}

