/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.ui.FileBotTab;
import net.filebot.ui.HistoryPanel;
import net.filebot.ui.SelectButtonTextField;
import net.filebot.ui.SelectDialog;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.ui.LabelProvider;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.SearchResult;
import net.miginfocom.swing.MigLayout;

public abstract class AbstractSearchPanel<S, E>
extends JComponent {
    protected final JPanel tabbedPaneGroup = new JPanel(new MigLayout("nogrid, fill, insets 0", "align center", "[fill]8px[pref!]4px"));
    protected final JTabbedPane tabbedPane = new JTabbedPane();
    protected final HistoryPanel historyPanel = new HistoryPanel();
    protected final SelectButtonTextField<S> searchTextField = new SelectButtonTextField();
    protected final BasicEventList<String> searchHistory = new BasicEventList(100000);
    private final AbstractAction searchAction = new AbstractAction("Find", ResourceManager.getIcon("action.find")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == null || AbstractSearchPanel.this.searchTextField.getText().trim().isEmpty()) {
                return;
            }
            RequestProcessor request = AbstractSearchPanel.this.createRequestProcessor();
            if (request != null) {
                AbstractSearchPanel.this.search(request);
            }
        }
    };

    public AbstractSearchPanel() {
        this.historyPanel.setColumnHeader(2, "Duration");
        JScrollPane historyScrollPane = new JScrollPane(this.historyPanel, 20, 31);
        historyScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPane.addTab("History", ResourceManager.getIcon("action.find"), historyScrollPane);
        this.tabbedPaneGroup.setBorder(BorderFactory.createTitledBorder("Search Results"));
        this.tabbedPaneGroup.add((Component)this.tabbedPane, "grow, wrap");
        this.setLayout(new MigLayout("nogrid, novisualpadding, fill, insets 10px 10px 15px 10px", "align 45%", "[pref!]10px[fill]"));
        this.add(this.searchTextField);
        this.add((Component)new JButton(this.searchAction), "gap 16px, h 2+pref!, id search, sgy button");
        this.add((Component)this.tabbedPaneGroup, "newline, grow");
        this.searchTextField.getEditor().setAction(this.searchAction);
        this.searchTextField.getSelectButton().setModel(Arrays.asList(this.getSearchEngines()));
        this.searchTextField.getSelectButton().setLabelProvider(this.getSearchEngineLabelProvider());
        this.searchTextField.getSelectButton().addPropertyChangeListener("selected value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                new SwingWorker<Collection<String>, Void>(){
                    private final S engine;
                    {
                        this.engine = AbstractSearchPanel.this.searchTextField.getSelectButton().getSelectedValue();
                    }

                    @Override
                    protected Collection<String> doInBackground() throws Exception {
                        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                        set.addAll(AbstractSearchPanel.this.getHistory(this.engine));
                        return set;
                    }

                    @Override
                    protected void done() {
                        if (this.engine == AbstractSearchPanel.this.searchTextField.getSelectButton().getSelectedValue()) {
                            try {
                                AbstractSearchPanel.this.searchHistory.clear();
                                AbstractSearchPanel.this.searchHistory.addAll((Collection)this.get());
                            }
                            catch (Exception e) {
                                Logging.debug.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                    }
                }.execute();
            }
        });
        try {
            this.searchTextField.getSelectButton().setSelectedIndex(Integer.parseInt(this.getSettings().get("engine.selected", "0")));
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, e.getMessage(), e);
        }
        this.searchTextField.getSelectButton().getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractSearchPanel.this.getSettings().put("engine.selected", Integer.toString(AbstractSearchPanel.this.searchTextField.getSelectButton().getSelectedIndex()));
            }
        });
        AutoCompleteSupport<String> acs = AutoCompleteSupport.install(this.searchTextField.getEditor(), this.searchHistory);
        acs.setTextMatchingStrategy(TextMatcherEditor.IDENTICAL_STRATEGY);
        acs.setFilterMode(0);
        acs.setCorrectsCase(true);
        acs.setStrict(false);
        SwingUI.installAction(this, KeyStroke.getKeyStroke(10, 0), this.searchAction);
    }

    protected abstract Collection<String> getHistory(S var1) throws Exception;

    protected abstract S[] getSearchEngines();

    protected abstract LabelProvider<S> getSearchEngineLabelProvider();

    protected abstract Settings getSettings();

    protected abstract RequestProcessor<?, E> createRequestProcessor();

    private void search(RequestProcessor<?, E> requestProcessor) {
        FileBotTab tab = ((RequestProcessor)requestProcessor).tab;
        tab.setTitle(requestProcessor.getTitle());
        tab.setLoading(true);
        tab.setIcon(requestProcessor.getIcon());
        tab.addTo(this.tabbedPane);
        this.tabbedPane.setSelectedComponent(tab);
        new SearchTask(requestProcessor).execute();
    }

    protected static abstract class RequestProcessor<R extends Request, E> {
        protected final R request;
        private FileBotTab<JComponent> tab;
        private SearchResult searchResult;
        private long duration = 0L;

        public RequestProcessor(R request, JComponent component) {
            this.request = request;
            this.tab = new FileBotTab<JComponent>(component);
        }

        public abstract Collection<? extends SearchResult> search() throws Exception;

        public abstract Collection<E> fetch() throws Exception;

        public abstract void process(Collection<E> var1);

        public abstract URI getLink();

        public JComponent getComponent() {
            return this.tab.getComponent();
        }

        public SearchResult getSearchResult() {
            return this.searchResult;
        }

        public void setSearchResult(SearchResult searchResult) {
            this.searchResult = searchResult;
        }

        public String getStatusMessage(Collection<E> result) {
            return String.format("%d elements found", result.size());
        }

        public String getTitle() {
            if (this.searchResult != null) {
                return this.searchResult.getName();
            }
            return ((Request)this.request).getSearchText();
        }

        public Icon getIcon() {
            return null;
        }

        protected SearchResult selectSearchResult(Collection<? extends SearchResult> searchResults, Window window) throws Exception {
            SelectDialog<SearchResult> selectDialog = new SelectDialog<SearchResult>((Component)window, searchResults);
            this.configureSelectDialog(selectDialog);
            selectDialog.setVisible(true);
            return selectDialog.getSelectedValue();
        }

        protected void configureSelectDialog(SelectDialog<SearchResult> selectDialog) {
            selectDialog.setLocation(SwingUI.getOffsetLocation(selectDialog.getOwner()));
            selectDialog.setIconImage(SwingUI.getImage(this.getIcon()));
            selectDialog.setMinimumSize(new Dimension(250, 150));
            selectDialog.pack();
        }

        public long getDuration() {
            return this.duration;
        }
    }

    protected static class Request {
        private final String searchText;

        public Request(String searchText) {
            this.searchText = searchText;
        }

        public String getSearchText() {
            return this.searchText;
        }
    }

    private class FetchTask
    extends SwingWorker<Collection<E>, Void> {
        private final RequestProcessor<?, E> requestProcessor;

        public FetchTask(RequestProcessor<?, E> requestProcessor) {
            this.requestProcessor = requestProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final Collection<E> doInBackground() throws Exception {
            long start = System.currentTimeMillis();
            try {
                Collection collection = this.requestProcessor.fetch();
                return collection;
            }
            finally {
                this.requestProcessor.duration += System.currentTimeMillis() - start;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            FileBotTab tab = this.requestProcessor.tab;
            if (tab.isClosed()) {
                return;
            }
            try {
                Collection elements = (Collection)this.get();
                this.requestProcessor.process(elements);
                String title = this.requestProcessor.getTitle();
                Icon icon = this.requestProcessor.getIcon();
                String statusMessage = this.requestProcessor.getStatusMessage(elements);
                AbstractSearchPanel.this.historyPanel.add(title, this.requestProcessor.getLink(), icon, statusMessage, String.format("%,d ms", this.requestProcessor.getDuration()));
                if (((Collection)this.get()).size() <= 0) {
                    Logging.log.warning(statusMessage);
                    tab.close();
                }
            }
            catch (Exception e) {
                tab.close();
                Logging.log.log(Level.WARNING, ExceptionUtilities.getRootCauseMessage(e), e);
            }
            finally {
                tab.setLoading(false);
            }
        }
    }

    private class SearchTask
    extends SwingWorker<Collection<? extends SearchResult>, Void> {
        private final RequestProcessor<?, E> requestProcessor;

        public SearchTask(RequestProcessor<?, E> requestProcessor) {
            this.requestProcessor = requestProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Collection<? extends SearchResult> doInBackground() throws Exception {
            long start = System.currentTimeMillis();
            try {
                Collection<SearchResult> collection = this.requestProcessor.search();
                return collection;
            }
            finally {
                this.requestProcessor.duration += System.currentTimeMillis() - start;
            }
        }

        @Override
        public void done() {
            FileBotTab tab = this.requestProcessor.tab;
            if (tab.isClosed()) {
                return;
            }
            try {
                Collection results = (Collection)this.get();
                SearchResult selectedSearchResult = null;
                switch (results.size()) {
                    case 0: {
                        Logging.log.log(Level.WARNING, String.format("'%s' has not been found.", ((Request)this.requestProcessor.request).getSearchText()));
                        break;
                    }
                    case 1: {
                        selectedSearchResult = (SearchResult)results.iterator().next();
                        break;
                    }
                    default: {
                        selectedSearchResult = this.requestProcessor.selectSearchResult(results, SwingUtilities.getWindowAncestor(AbstractSearchPanel.this));
                    }
                }
                if (selectedSearchResult == null) {
                    tab.close();
                    return;
                }
                this.requestProcessor.setSearchResult(selectedSearchResult);
                tab.setTitle(this.requestProcessor.getTitle());
                new FetchTask(this.requestProcessor).execute();
            }
            catch (Exception e) {
                tab.close();
                Logging.log.log(Level.WARNING, ExceptionUtilities.getRootCauseMessage(e), e);
            }
        }
    }
}

