/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.filebot.ResourceManager;
import net.filebot.util.ui.ProgressIndicator;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

public class FileBotTabComponent
extends JComponent {
    private ProgressIndicator progressIndicator = new ProgressIndicator();
    private JLabel textLabel = new JLabel();
    private JLabel iconLabel = new JLabel();
    private AbstractButton closeButton = this.createCloseButton();
    private boolean loading = false;

    public FileBotTabComponent() {
        this.iconLabel.setHorizontalAlignment(0);
        this.textLabel.setHorizontalAlignment(2);
        this.progressIndicator.setVisible(this.loading);
        this.progressIndicator.setMinimumSize(new Dimension(16, 16));
        this.setLayout(new MigLayout("nogrid, insets 0 0 1 3"));
        this.add((Component)this.progressIndicator, "hidemode 3");
        this.add((Component)this.iconLabel, "hidemode 3");
        this.add((Component)this.textLabel, "gap rel, align left");
        this.add((Component)this.closeButton, "gap unrel:push, hidemode 3, align center 45%");
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
        this.progressIndicator.setVisible(loading);
        this.iconLabel.setVisible(!loading);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setIcon(Icon icon) {
        this.iconLabel.setIcon(icon);
        this.progressIndicator.setPreferredSize(icon != null ? SwingUI.getDimension(icon) : this.progressIndicator.getMinimumSize());
    }

    public Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    public String getText() {
        return this.textLabel.getText();
    }

    public AbstractButton getCloseButton() {
        return this.closeButton;
    }

    protected AbstractButton createCloseButton() {
        Icon icon = ResourceManager.getIcon("tab.close");
        Icon rolloverIcon = ResourceManager.getIcon("tab.close.hover");
        JButton button = new JButton(icon);
        button.setRolloverIcon(rolloverIcon);
        button.setPreferredSize(SwingUI.getDimension(rolloverIcon));
        button.setMaximumSize(button.getPreferredSize());
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setFocusable(false);
        button.setRolloverEnabled(true);
        return button;
    }
}

