/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui;

import java.awt.Color;
import java.awt.Component;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.filebot.util.ui.LinkButton;
import net.miginfocom.swing.MigLayout;

public class HistoryPanel
extends JPanel {
    private final List<JLabel> columnHeaders = new ArrayList<JLabel>(3);

    public HistoryPanel() {
        super(new MigLayout("fillx, insets 10 30 10 50, wrap 3"));
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setupHeader();
    }

    private void setupHeader() {
        for (int i = 0; i < 3; ++i) {
            JLabel columnHeader = new JLabel();
            columnHeader.setFont(columnHeader.getFont().deriveFont(1));
            this.columnHeaders.add(columnHeader);
            this.add((Component)columnHeader, this.getHeaderConstraint(i));
        }
    }

    private String getHeaderConstraint(int headerIndex) {
        switch (headerIndex) {
            case 0: {
                return "align left, gapbefore 24";
            }
            case 1: {
                return "align center";
            }
        }
        return "align right, gapafter 12";
    }

    public void setColumnHeader(int index, String text) {
        this.columnHeaders.get(index).setText(text);
    }

    public void add(String column1, URI link, Icon icon, String column2, String column3) {
        JComponent c1 = link != null ? new LinkButton(column1, null, icon, link) : new JLabel(column1, icon, 2);
        JLabel c2 = new JLabel(column2, 4);
        JLabel c3 = new JLabel(column3, 4);
        this.add((Component)c1, "align left");
        this.add((Component)c2, "align center, wmin 100");
        this.add((Component)c3, "align right");
    }
}

