/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.episodelist;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import net.filebot.Language;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.media.MediaDetection;
import net.filebot.similarity.Normalization;
import net.filebot.ui.AbstractSearchPanel;
import net.filebot.ui.FileBotList;
import net.filebot.ui.LanguageComboBox;
import net.filebot.ui.PanelBuilder;
import net.filebot.ui.SelectDialog;
import net.filebot.ui.episodelist.EpisodeListExportHandler;
import net.filebot.ui.episodelist.SeasonSpinnerEditor;
import net.filebot.ui.episodelist.SeasonSpinnerModel;
import net.filebot.ui.transfer.SaveAction;
import net.filebot.util.ui.LabelProvider;
import net.filebot.util.ui.SimpleLabelProvider;
import net.filebot.util.ui.SwingEventBus;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.EpisodeUtilities;
import net.filebot.web.SearchResult;
import net.filebot.web.SeasonOutOfBoundsException;
import net.filebot.web.SortOrder;

public class EpisodeListPanel
extends AbstractSearchPanel<EpisodeListProvider, Episode> {
    private SeasonSpinnerModel seasonSpinnerModel = new SeasonSpinnerModel();
    private LanguageComboBox languageComboBox = new LanguageComboBox(Language.getLanguage("en"), this.getSettings());
    private JComboBox sortOrderComboBox = new JComboBox<SortOrder>(SortOrder.values());
    private final PropertyChangeListener selectButtonListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EpisodeListProvider provider = (EpisodeListProvider)EpisodeListPanel.this.searchTextField.getSelectButton().getSelectedValue();
            if (!provider.hasSeasonSupport()) {
                EpisodeListPanel.this.seasonSpinnerModel.lock(0);
            } else {
                EpisodeListPanel.this.seasonSpinnerModel.unlock();
            }
        }
    };

    public EpisodeListPanel() {
        this.historyPanel.setColumnHeader(0, "TV Series");
        this.historyPanel.setColumnHeader(1, "Number of Episodes");
        JSpinner seasonSpinner = new JSpinner(this.seasonSpinnerModel);
        seasonSpinner.setEditor(new SeasonSpinnerEditor(seasonSpinner));
        Dimension d = seasonSpinner.getPreferredSize();
        d.width += 12;
        seasonSpinner.setMinimumSize(d);
        this.add(seasonSpinner, "sgy button, gap indent", 1);
        this.add(this.sortOrderComboBox, "sgy button, gap rel", 2);
        this.add(this.languageComboBox, "sgy button, gap indent+5", 3);
        this.searchTextField.getSelectButton().addPropertyChangeListener("selected value", this.selectButtonListener);
        SwingUI.installAction(this, KeyStroke.getKeyStroke(38, 64), new SpinSeasonAction(1));
        SwingUI.installAction(this, KeyStroke.getKeyStroke(40, 64), new SpinSeasonAction(-1));
    }

    @Override
    protected Collection<String> getHistory(EpisodeListProvider engine) throws Exception {
        SearchResult[] index;
        ArrayList<String> names = new ArrayList<String>(100000);
        for (SearchResult it : index = engine == WebServices.AniDB ? MediaDetection.releaseInfo.getAnidbIndex() : MediaDetection.releaseInfo.getTheTVDBIndex()) {
            for (String n : it.getEffectiveNames()) {
                names.add(Normalization.removeTrailingBrackets(n));
            }
        }
        return names;
    }

    protected EpisodeListProvider[] getSearchEngines() {
        return WebServices.getEpisodeListProviders();
    }

    @Override
    protected LabelProvider<EpisodeListProvider> getSearchEngineLabelProvider() {
        return SimpleLabelProvider.forClass(EpisodeListProvider.class);
    }

    @Override
    protected Settings getSettings() {
        return Settings.forPackage(EpisodeListPanel.class);
    }

    protected EpisodeListRequestProcessor createRequestProcessor() {
        EpisodeListProvider provider = (EpisodeListProvider)this.searchTextField.getSelectButton().getSelectedValue();
        String text = this.searchTextField.getText().trim();
        int season = this.seasonSpinnerModel.getSeason();
        SortOrder order = (SortOrder)((Object)this.sortOrderComboBox.getSelectedItem());
        Locale language = this.languageComboBox.getModel().getSelectedItem().getLocale();
        return new EpisodeListRequestProcessor(new EpisodeListRequest(provider, text, season, order, language));
    }

    protected static class EpisodeListTab
    extends FileBotList<Episode> {
        public EpisodeListTab() {
            EpisodeListExportHandler exportHandler = new EpisodeListExportHandler(this);
            this.setExportHandler(exportHandler);
            this.getTransferHandler().setClipboardHandler(exportHandler);
            this.getRemoveAction().setEnabled(true);
            this.listScrollPane.setBorder(null);
            this.setBorder(null);
            JPopupMenu popup = new JPopupMenu("Episodes");
            JMenu menu = new JMenu("Send to");
            for (PanelBuilder panel : PanelBuilder.episodeHandlerSequence()) {
                menu.add(SwingUI.newAction(panel.getName(), panel.getIcon(), evt -> {
                    SwingEventBus.getInstance().post(panel);
                    SwingUI.invokeLater(200, () -> SwingEventBus.getInstance().post(exportHandler.export(this, false)));
                }));
            }
            popup.add(menu);
            popup.addSeparator();
            popup.add(SwingUI.newAction("Copy", ResourceManager.getIcon("rename.action.copy"), evt -> this.getTransferHandler().getClipboardHandler().exportToClipboard(this, Toolkit.getDefaultToolkit().getSystemClipboard(), 1)));
            popup.add(new SaveAction(this.getExportHandler()));
            this.getListComponent().setComponentPopupMenu(popup);
        }
    }

    protected static class EpisodeListRequestProcessor
    extends AbstractSearchPanel.RequestProcessor<EpisodeListRequest, Episode> {
        public EpisodeListRequestProcessor(EpisodeListRequest request) {
            super(request, new EpisodeListTab());
        }

        @Override
        public Collection<SearchResult> search() throws Exception {
            return ((EpisodeListRequest)this.request).provider.search(((EpisodeListRequest)this.request).getSearchText(), ((EpisodeListRequest)this.request).language);
        }

        @Override
        public Collection<Episode> fetch() throws Exception {
            List<Episode> episodes = ((EpisodeListRequest)this.request).provider.getEpisodeList(this.getSearchResult(), ((EpisodeListRequest)this.request).order, ((EpisodeListRequest)this.request).language);
            if (((EpisodeListRequest)this.request).season != 0) {
                List<Episode> episodeForSeason = EpisodeUtilities.filterBySeason(episodes, ((EpisodeListRequest)this.request).season);
                if (episodeForSeason.isEmpty()) {
                    throw new SeasonOutOfBoundsException(this.getSearchResult().getName(), ((EpisodeListRequest)this.request).season, EpisodeUtilities.getLastSeason(episodes));
                }
                episodes = episodeForSeason;
            }
            return episodes;
        }

        @Override
        public URI getLink() {
            return ((EpisodeListRequest)this.request).provider.getEpisodeListLink(this.getSearchResult());
        }

        @Override
        public void process(Collection<Episode> episodes) {
            this.getComponent().setTitle(this.getTitle());
            this.getComponent().getModel().addAll(episodes);
        }

        @Override
        public String getStatusMessage(Collection<Episode> result) {
            return result.isEmpty() ? "No episodes found" : String.format("%d episodes", result.size());
        }

        @Override
        public EpisodeListTab getComponent() {
            return (EpisodeListTab)super.getComponent();
        }

        @Override
        public String getTitle() {
            if (((EpisodeListRequest)this.request).season == 0) {
                return super.getTitle();
            }
            return String.format("%s - Season %d", super.getTitle(), ((EpisodeListRequest)this.request).season);
        }

        @Override
        public Icon getIcon() {
            return ((EpisodeListRequest)this.request).provider.getIcon();
        }

        @Override
        protected void configureSelectDialog(SelectDialog<SearchResult> selectDialog) {
            super.configureSelectDialog(selectDialog);
            selectDialog.getMessageLabel().setText("Select a Show:");
        }
    }

    protected static class EpisodeListRequest
    extends AbstractSearchPanel.Request {
        public final EpisodeListProvider provider;
        public final int season;
        public final SortOrder order;
        public final Locale language;

        public EpisodeListRequest(EpisodeListProvider provider, String searchText, int season, SortOrder order, Locale language) {
            super(searchText);
            this.provider = provider;
            this.season = season;
            this.order = order;
            this.language = language;
        }
    }

    private class SpinSeasonAction
    extends AbstractAction {
        public SpinSeasonAction(int spin) {
            super(String.format("Spin%+d", spin));
            this.putValue("spin", spin);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EpisodeListPanel.this.seasonSpinnerModel.spin((Integer)this.getValue("spin"));
        }
    }
}

