/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.UserFiles;
import net.filebot.archive.Archive;
import net.filebot.archive.FileMapper;
import net.filebot.cli.ConflictAction;
import net.filebot.ui.filter.Tool;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.LoadingOverlayPane;
import net.filebot.util.ui.ProgressMonitor;
import net.filebot.util.ui.SwingUI;
import net.filebot.util.ui.notification.SeparatorBorder;
import net.filebot.vfs.FileInfo;
import net.filebot.vfs.SimpleFileInfo;
import net.miginfocom.swing.MigLayout;

class ExtractTool
extends Tool<TableModel> {
    private JTable table = new JTable(new ArchiveEntryModel());
    private Action extractAction = SwingUI.newAction("Extract All", ResourceManager.getIcon("package.extract"), evt -> {
        List<File> archives = ((ArchiveEntryModel)this.table.getModel()).getArchiveList();
        if (archives.isEmpty()) {
            return;
        }
        File selectedFile = UserFiles.showOpenDialogSelectFolder(archives.get(0).getParentFile(), "Extract to ...", evt);
        if (selectedFile == null) {
            return;
        }
        ExtractWorker worker = new ExtractWorker(archives, selectedFile, null, true, ConflictAction.AUTO);
        ProgressMonitor.runTask("Extract", "Extracting files...", worker);
    });

    public ExtractTool() {
        super("Archives");
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoResizeMode(2);
        this.table.setSelectionMode(2);
        this.table.setBackground(Color.white);
        this.table.setGridColor(new Color(0xEEEEEE));
        this.table.setRowHeight(25);
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        tableScrollPane.setBorder(new SeparatorBorder(2, new Color(0, 0, 0, 90), GradientStyle.TOP_TO_BOTTOM, SeparatorBorder.Position.BOTTOM));
        this.setLayout(new MigLayout("insets 0, nogrid, fill", "align center", "[fill][pref!]"));
        this.add((Component)new LoadingOverlayPane(tableScrollPane, this, "25px", "30px"), "grow, wrap");
        this.add((Component)new JButton(this.extractAction), "gap top rel, gap bottom unrel");
    }

    @Override
    protected void setModel(TableModel model) {
        this.table.setModel(model);
    }

    @Override
    protected TableModel createModelInBackground(List<File> root) throws Exception {
        if (root.isEmpty()) {
            return new ArchiveEntryModel();
        }
        List<File> files = FileUtilities.listFiles(root, Archive.VOLUME_ONE_FILTER, FileUtilities.HUMAN_NAME_ORDER);
        ArrayList<ArchiveEntry> entries = new ArrayList<ArchiveEntry>();
        for (File file : files) {
            try (Archive archive = Archive.open(file);){
                for (FileInfo it : archive.listFiles()) {
                    entries.add(new ArchiveEntry(file, it));
                }
            }
            if (!Thread.interrupted()) continue;
            throw new CancellationException();
        }
        return new ArchiveEntryModel(entries);
    }

    private static class ExtractWorker
    implements ProgressMonitor.ProgressWorker<Void> {
        private final File[] archives;
        private final File outputFolder;
        private final FileFilter filter;
        private final boolean forceExtractAll;
        private final ConflictAction conflictAction;

        public ExtractWorker(Collection<File> archives, File outputFolder, FileFilter filter, boolean forceExtractAll, ConflictAction conflictAction) {
            this.archives = archives.toArray(new File[archives.size()]);
            this.outputFolder = outputFolder;
            this.filter = filter;
            this.forceExtractAll = forceExtractAll;
            this.conflictAction = conflictAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call(Consumer<String> message, BiConsumer<Long, Long> progress, Supplier<Boolean> cancelled) throws Exception {
            for (File file : this.archives) {
                try {
                    message.accept(String.format("Extracting %s", file.getName()));
                    try (Archive archive = Archive.open(file);){
                        int n;
                        FileMapper outputMapper = new FileMapper(this.outputFolder);
                        ArrayList<SimpleFileInfo> outputMapping = new ArrayList<SimpleFileInfo>();
                        for (FileInfo fileInfo : archive.listFiles()) {
                            File outputPath = outputMapper.getOutputFile(fileInfo.toFile());
                            outputMapping.add(new SimpleFileInfo(outputPath.getPath(), fileInfo.getLength()));
                        }
                        TreeSet<FileInfo> selection = new TreeSet<FileInfo>();
                        for (FileInfo future : outputMapping) {
                            if (this.filter != null && !this.filter.accept(future.toFile())) continue;
                            selection.add(future);
                        }
                        if (selection.isEmpty()) continue;
                        boolean bl = true;
                        for (FileInfo future : this.filter == null || this.forceExtractAll ? outputMapping : selection) {
                            if (this.conflictAction == ConflictAction.AUTO) {
                                n &= future.toFile().exists() && future.getLength() == future.toFile().length() ? 1 : 0;
                                continue;
                            }
                            n &= future.toFile().exists();
                        }
                        if (n == 0 || this.conflictAction == ConflictAction.OVERRIDE) {
                            if (this.filter == null || this.forceExtractAll) {
                                archive.extract(outputMapper.getOutputDir());
                            } else {
                                archive.extract(outputMapper.getOutputDir(), outputMapper.newPathFilter((Collection<FileInfo>)selection));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logging.log.log(Level.WARNING, "Failed to extract archive: " + file.getName(), e);
                }
                if (!cancelled.get().booleanValue()) continue;
                throw new CancellationException("Extract cancelled");
            }
            return null;
        }
    }

    private static class ArchiveEntryModel
    extends AbstractTableModel {
        private final ArchiveEntry[] data;

        public ArchiveEntryModel() {
            this.data = new ArchiveEntry[0];
        }

        public ArchiveEntryModel(Collection<ArchiveEntry> data) {
            this.data = data.toArray(new ArchiveEntry[data.size()]);
        }

        public List<File> getArchiveList() {
            LinkedHashSet<File> archives = new LinkedHashSet<File>();
            for (ArchiveEntry it : this.data) {
                archives.add(it.archive);
            }
            return new ArrayList<File>(archives);
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "File";
                }
                case 1: {
                    return "Path";
                }
                case 2: {
                    return "Size";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.data[row].entry.getName();
                }
                case 1: {
                    File root = new File(this.data[row].archive.getName());
                    File prefix = this.data[row].entry.toFile().getParentFile();
                    File path = prefix == null ? root : new File(root, prefix.getPath());
                    return FileUtilities.normalizePathSeparators(path.getPath());
                }
                case 2: {
                    return FileUtilities.formatSize(this.data[row].entry.getLength());
                }
            }
            return null;
        }
    }

    private static class ArchiveEntry {
        public final File archive;
        public final FileInfo entry;

        public ArchiveEntry(File archive, FileInfo entry) {
            this.archive = archive;
            this.entry = entry;
        }
    }
}

