/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import net.filebot.ui.filter.FileTreePanel;
import net.filebot.ui.filter.Tool;
import net.filebot.ui.transfer.TransferablePolicy;
import net.miginfocom.swing.MigLayout;

public class FilterPanel
extends JComponent {
    private final FileTreePanel fileTreePanel = new FileTreePanel();
    private final JTabbedPane toolsPanel = new JTabbedPane();

    public FilterPanel() {
        this.setLayout(new MigLayout("insets dialog, gapx 50, fill, nogrid"));
        this.add((Component)this.fileTreePanel, "grow 1, w 300:pref:500");
        this.add((Component)this.toolsPanel, "grow 2");
        this.fileTreePanel.addPropertyChangeListener("FILE_TREE", evt -> {
            for (int i = 0; i < this.toolsPanel.getTabCount(); ++i) {
                Tool tool = (Tool)this.toolsPanel.getComponentAt(i);
                tool.setRoot(this.fileTreePanel.getFileTree().getRoot());
            }
        });
    }

    public void addTool(Tool<?> tool) {
        this.toolsPanel.addTab(tool.getName(), tool);
    }

    @Subscribe
    public void handle(Transferable transferable) throws Exception {
        TransferablePolicy handler = this.fileTreePanel.getTransferablePolicy();
        if (handler != null && handler.accept(transferable)) {
            handler.handleTransferable(transferable, TransferablePolicy.TransferAction.PUT);
        }
    }
}

