/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.ui.filter.Tool;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.LoadingOverlayPane;
import net.miginfocom.swing.MigLayout;

class MediaInfoTool
extends Tool<TableModel> {
    private JTable table = new JTable(new MediaInfoTableModel());

    public MediaInfoTool() {
        super("MediaInfo");
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setFillsViewportHeight(true);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(2);
        this.table.setBackground(Color.white);
        this.table.setGridColor(new Color(0xEEEEEE));
        this.table.setRowHeight(25);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new MigLayout("insets 0, fill"));
        this.add((Component)new LoadingOverlayPane(scrollPane, this), "grow");
    }

    @Override
    protected TableModel createModelInBackground(List<File> root) {
        if (root.isEmpty()) {
            return new MediaInfoTableModel();
        }
        List<File> files = FileUtilities.listFiles(root, FileUtilities.filter(MediaTypes.VIDEO_FILES, MediaTypes.AUDIO_FILES), FileUtilities.HUMAN_NAME_ORDER);
        TreeMap<MediaInfoKey, String[]> data = new TreeMap<MediaInfoKey, String[]>();
        try (MediaInfo mi = new MediaInfo();){
            IntStream.range(0, files.size()).forEach(f -> {
                try {
                    mi.open((File)files.get(f));
                    mi.snapshot().forEach((kind, streams) -> IntStream.range(0, streams.size()).forEach(i -> ((Map)streams.get(i)).forEach((name, value) -> {
                        String[] values = data.computeIfAbsent(new MediaInfoKey((MediaInfo.StreamKind)((Object)((Object)kind)), i, (String)name), k -> new String[files.size()]);
                        values[f] = value;
                    })));
                }
                catch (IllegalArgumentException e) {
                    Logging.debug.finest(e::toString);
                }
                catch (Exception e) {
                    Logging.debug.warning(e::toString);
                }
                if (Thread.interrupted()) {
                    throw new CancellationException();
                }
            });
        }
        return new MediaInfoTableModel(data.isEmpty() ? Collections.emptyList() : files, data);
    }

    @Override
    protected void setModel(TableModel model) {
        this.table.setModel(model);
        this.table.setAutoResizeMode(this.table.getRowCount() > 0 ? 0 : 2);
        TableColumnModel columnModel = this.table.getColumnModel();
        IntStream.range(0, columnModel.getColumnCount()).forEach(i -> columnModel.getColumn(i).setMinWidth(150));
    }

    private static class MediaInfoTableModel
    extends AbstractTableModel {
        private final MediaInfoKey[] keys;
        private final String[][] values;
        private final String[] files;
        private final Class<?>[] columnClass;

        public MediaInfoTableModel() {
            this(Collections.emptyList(), Collections.emptyMap());
        }

        public MediaInfoTableModel(List<File> files, Map<MediaInfoKey, String[]> values) {
            this.keys = values.keySet().toArray(new MediaInfoKey[0]);
            this.values = (String[][])values.values().toArray((T[])new String[0][]);
            this.files = (String[])files.stream().map(File::getName).toArray(String[]::new);
            this.columnClass = new Class[this.getColumnCount()];
        }

        public int getHeaderColumnCount() {
            return 1;
        }

        @Override
        public int getColumnCount() {
            return this.keys.length + this.getHeaderColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "File";
                }
            }
            return this.keys[column - this.getHeaderColumnCount()].toString();
        }

        private boolean isNumber(String s) {
            try {
                Double.parseDouble(s);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Class<?> getColumnClass(int column) {
            int c = column - this.getHeaderColumnCount();
            if (c < 0) {
                return String.class;
            }
            if (this.columnClass[c] != null) {
                return this.columnClass[c];
            }
            if (IntStream.range(0, this.files.length).mapToObj(i -> this.values[c][i]).filter(Objects::nonNull).allMatch(this::isNumber)) {
                this.columnClass[c] = Number.class;
                return this.columnClass[c];
            }
            this.columnClass[c] = String.class;
            return this.columnClass[c];
        }

        @Override
        public int getRowCount() {
            return this.files.length;
        }

        @Override
        public String getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.files[row];
                }
            }
            return this.values[column - this.getHeaderColumnCount()][row];
        }
    }

    private static class MediaInfoKey
    implements Comparable<MediaInfoKey> {
        public final MediaInfo.StreamKind kind;
        public final int stream;
        public final String name;
        private static final Pattern strip = Pattern.compile("[^a-z]", 2);

        public MediaInfoKey(MediaInfo.StreamKind kind, int stream, String name) {
            this.kind = kind;
            this.stream = stream;
            this.name = strip.matcher(name).replaceAll("");
        }

        public boolean equals(Object obj) {
            if (obj instanceof MediaInfoKey) {
                MediaInfoKey other = (MediaInfoKey)obj;
                return this.kind == other.kind && this.stream == other.stream && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.ordinal() + (this.stream << 8) + this.name.hashCode();
        }

        @Override
        public int compareTo(MediaInfoKey other) {
            if (this.kind != other.kind) {
                return this.kind.compareTo(other.kind);
            }
            if (this.stream != other.stream) {
                return Integer.compare(this.stream, other.stream);
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.kind != MediaInfo.StreamKind.General) {
                sb.append(this.kind.name());
                if (this.stream > 0) {
                    sb.append('[').append(this.stream).append(']');
                }
                sb.append('.');
            }
            return sb.append(this.name).toString();
        }
    }
}

