/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.filter;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.filebot.ui.filter.FileTree;
import net.filebot.ui.filter.FileTreeExportHandler;
import net.filebot.ui.filter.Tool;
import net.filebot.ui.transfer.DefaultTransferHandler;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.GradientStyle;
import net.filebot.util.ui.LoadingOverlayPane;
import net.filebot.util.ui.notification.SeparatorBorder;
import net.miginfocom.swing.MigLayout;

class SplitTool
extends Tool<TreeModel> {
    private FileTree tree = new FileTree();
    private SpinnerNumberModel spinnerModel = new SpinnerNumberModel(4480, 0, Integer.MAX_VALUE, 100);

    public SplitTool() {
        super("Parts");
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setBorder(new SeparatorBorder(2, new Color(0, 0, 0, 90), GradientStyle.TOP_TO_BOTTOM, SeparatorBorder.Position.BOTTOM));
        JSpinner spinner = new JSpinner(this.spinnerModel);
        spinner.setEditor(new JSpinner.NumberEditor(spinner, "#"));
        this.setLayout(new MigLayout("insets 0, nogrid, fill", "align center", "[fill][pref!]"));
        this.add((Component)new LoadingOverlayPane(treeScrollPane, this), "grow, wrap");
        this.add(new JLabel("Split every"));
        this.add((Component)spinner, "wmax 80, gap top rel, gap bottom unrel");
        this.add(new JLabel("MB"));
        this.tree.setTransferHandler(new DefaultTransferHandler(null, new FileTreeExportHandler()));
        this.tree.setDragEnabled(true);
        this.spinnerModel.addChangeListener(evt -> {
            List<File> root = this.getRoot();
            if (root.size() > 0) {
                this.setRoot(root);
            }
        });
    }

    private long getSplitSize() {
        return (long)this.spinnerModel.getNumber().intValue() * 1000000L;
    }

    @Override
    protected TreeModel createModelInBackground(List<File> root) {
        if (root.isEmpty()) {
            return new DefaultTreeModel(new FileTree.FolderNode("Volumes", Collections.emptyList()));
        }
        int nextPart = 1;
        long splitSize = this.getSplitSize();
        List<File> files = FileUtilities.listFiles(root, FileUtilities.FILES, FileUtilities.HUMAN_NAME_ORDER);
        ArrayList<TreeNode> rootGroup = new ArrayList<TreeNode>();
        ArrayList<File> currentPart = new ArrayList<File>();
        ArrayList<File> remainder = new ArrayList<File>();
        long totalSize = 0L;
        for (File f : files) {
            long fileSize = f.length();
            if (fileSize > splitSize) {
                remainder.add(f);
                continue;
            }
            if (totalSize + fileSize > splitSize) {
                rootGroup.add(this.createStatisticsNode(nextPart++, currentPart));
                totalSize = 0L;
                currentPart.clear();
            }
            totalSize += fileSize;
            currentPart.add(f);
            if (!Thread.interrupted()) continue;
            throw new CancellationException();
        }
        if (!currentPart.isEmpty()) {
            rootGroup.add(this.createStatisticsNode(nextPart++, currentPart));
        }
        if (!remainder.isEmpty()) {
            rootGroup.add(this.createStatisticsNode("Remainder", remainder));
        }
        return new DefaultTreeModel(new FileTree.FolderNode("Volumes", rootGroup));
    }

    protected FileTree.FolderNode createStatisticsNode(int disk, List<File> files) {
        return this.createStatisticsNode(String.format("Disk %,d", disk), files);
    }

    @Override
    protected void setModel(TreeModel model) {
        this.tree.setModel(model);
    }
}

