/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.list;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.filebot.MediaTypes;
import net.filebot.torrent.Torrent;
import net.filebot.ui.transfer.ArrayTransferable;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.ui.transfer.FileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.FileUtilities;
import net.filebot.web.Episode;

class FileListTransferablePolicy
extends FileTransferablePolicy {
    private static final DataFlavor episodeArrayFlavor = ArrayTransferable.flavor(Episode.class);
    private Consumer<String> title;
    private Consumer<String> format;
    private Consumer<List<?>> model;

    public FileListTransferablePolicy(Consumer<String> title, Consumer<String> format, Consumer<List<?>> model) {
        this.title = title;
        this.format = format;
        this.model = model;
    }

    @Override
    public boolean accept(Transferable tr) throws Exception {
        return FileTransferable.hasFileListFlavor(tr) || tr.isDataFlavorSupported(episodeArrayFlavor);
    }

    @Override
    public void handleTransferable(Transferable tr, TransferablePolicy.TransferAction action) throws Exception {
        if (tr.isDataFlavorSupported(episodeArrayFlavor)) {
            Episode[] episodes = (Episode[])tr.getTransferData(episodeArrayFlavor);
            if (episodes.length > 0) {
                this.format.accept("{n} - {s00e00} - [{absolute}] - [{airdate}] - {t}");
                this.title.accept(episodes[0].getSeriesName());
                this.model.accept(Arrays.asList(episodes));
            }
            return;
        }
        super.handleTransferable(tr, action);
    }

    @Override
    protected boolean accept(List<File> files) {
        return true;
    }

    @Override
    protected void clear() {
        this.format.accept("");
        this.title.accept("");
        this.model.accept(Collections.emptyList());
    }

    @Override
    protected void load(List<File> files, TransferablePolicy.TransferAction action) throws IOException {
        this.title.accept(FileUtilities.getFolderName(files.get(0).getParentFile()));
        if (FileUtilities.containsOnly(files, MediaTypes.TORRENT_FILES)) {
            this.loadTorrents(files);
        } else {
            if (files.size() == 1 && files.get(0).isDirectory()) {
                this.title.accept(FileUtilities.getFolderName(files.get(0)));
            }
            this.format.accept("{fn}");
            this.model.accept(FileUtilities.listFiles(files, FileUtilities.FILES, FileUtilities.HUMAN_NAME_ORDER));
        }
    }

    private void loadTorrents(List<File> files) throws IOException {
        ArrayList<Torrent> torrents = new ArrayList<Torrent>(files.size());
        for (File file : files) {
            torrents.add(new Torrent(file));
        }
        if (torrents.size() > 0) {
            this.title.accept(FileUtilities.getNameWithoutExtension(((Torrent)torrents.get(0)).getName()));
        }
        this.format.accept("{fn}");
        this.model.accept(torrents.stream().flatMap(t -> t.getFiles().stream()).collect(Collectors.toList()));
    }

    @Override
    public String getFileFilterDescription() {
        return "Files, Folders and Torrents";
    }

    @Override
    public List<String> getFileFilterExtensions() {
        return FileUtilities.ExtensionFileFilter.WILDCARD;
    }
}

