/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.list;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.filebot.format.Define;
import net.filebot.format.MediaBindingBean;
import net.filebot.media.XattrMetaInfo;
import net.filebot.util.EntryList;
import net.filebot.util.FunctionList;

public class IndexedBindingBean
extends MediaBindingBean {
    private int i;
    private int from;
    private int to;

    public IndexedBindingBean(Object object, int i, int from, int to, List<?> context) {
        super(IndexedBindingBean.getInfoObject(object), IndexedBindingBean.getMediaFile(object), IndexedBindingBean.getContext(context));
        this.i = i;
        this.from = from;
        this.to = to;
    }

    @Override
    @Define(value={"i"})
    public Integer getModelIndex() {
        return this.i;
    }

    @Define(value={"from"})
    public Integer getFromIndex() {
        return this.from;
    }

    @Define(value={"to"})
    public Integer getToIndex() {
        return this.to;
    }

    private static Object getInfoObject(Object object) {
        File file;
        Object metaInfo;
        if (object instanceof File && (metaInfo = XattrMetaInfo.xattr.getMetaInfo(file = (File)object)) != null) {
            return metaInfo;
        }
        return object;
    }

    private static File getMediaFile(Object object) {
        return object instanceof File ? (File)object : new File(object.toString());
    }

    private static Map<File, Object> getContext(List<?> context) {
        FunctionList<Object, Object> values = new FunctionList<Object, Object>(context, IndexedBindingBean::getInfoObject);
        FunctionList<Object, File> files = new FunctionList<Object, File>(context, IndexedBindingBean::getMediaFile);
        return new EntryList<File, Object>(files, values);
    }
}

