/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.filebot.Logging;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.media.AutoDetection;
import net.filebot.similarity.Match;
import net.filebot.ui.rename.AutoCompleteMatcher;
import net.filebot.ui.rename.EpisodeListMatcher;
import net.filebot.ui.rename.MovieMatcher;
import net.filebot.ui.rename.MusicMatcher;
import net.filebot.ui.rename.OriginalOrder;
import net.filebot.util.ExceptionUtilities;
import net.filebot.web.SortOrder;

class AutoDetectMatcher
implements AutoCompleteMatcher {
    private AutoCompleteMatcher movie = new MovieMatcher(WebServices.TheMovieDB);
    private AutoCompleteMatcher episode = new EpisodeListMatcher(WebServices.TheTVDB, false);
    private AutoCompleteMatcher anime = new EpisodeListMatcher(WebServices.AniDB, true);
    private AutoCompleteMatcher music = new MusicMatcher(WebServices.MediaInfoID3, WebServices.AcoustID);

    AutoDetectMatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Match<File, ?>> match(Collection<File> files, boolean strict, SortOrder order, Locale locale, boolean autodetection, Component parent) throws Exception {
        Map<AutoDetection.Group, Set<File>> groups = new AutoDetection(files, false, locale).group();
        ExecutorService workerThreadPool = Executors.newFixedThreadPool(Settings.getPreferredThreadPoolSize());
        try {
            List matches = groups.entrySet().stream().filter(it -> ((AutoDetection.Group)it.getKey()).types().length == 1).map(it -> workerThreadPool.submit(() -> this.match((AutoDetection.Group)it.getKey(), (Collection)it.getValue(), strict, order, locale, autodetection, parent))).collect(Collectors.toList());
            List<Match<File, ?>> list = matches.stream().flatMap(it -> {
                try {
                    return ((List)it.get()).stream();
                }
                catch (Exception e) {
                    if (ExceptionUtilities.findCause(e, CancellationException.class) == null) {
                        Logging.log.log(Level.WARNING, e, Logging.cause("Failed to match group", e));
                    }
                    return Stream.empty();
                }
            }).sorted(Comparator.comparing(Match::getValue, OriginalOrder.of(files))).collect(Collectors.toList());
            return list;
        }
        finally {
            workerThreadPool.shutdownNow();
        }
    }

    private List<Match<File, ?>> match(AutoDetection.Group group, Collection<File> files, boolean strict, SortOrder order, Locale locale, boolean autodetection, Component parent) throws Exception {
        AutoCompleteMatcher m = this.getMatcher(group);
        if (m != null) {
            return m.match(files, strict, order, locale, autodetection, parent);
        }
        return Collections.emptyList();
    }

    private AutoCompleteMatcher getMatcher(AutoDetection.Group group) {
        for (AutoDetection.Type key : group.types()) {
            switch (key) {
                case Movie: {
                    return this.movie;
                }
                case Series: {
                    return this.episode;
                }
                case Anime: {
                    return this.anime;
                }
                case Music: {
                    return this.music;
                }
            }
        }
        return null;
    }
}

