/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.ResourceManager;
import net.filebot.UserFiles;
import net.filebot.format.ExpressionFormat;
import net.filebot.format.MediaBindingBean;
import net.filebot.media.XattrMetaInfo;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.util.DefaultThreadFactory;
import net.filebot.util.FileUtilities;
import net.filebot.util.JsonUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

class BindingDialog
extends JDialog {
    private final JTextField infoTextField = new JTextField();
    private final JTextField mediaFileTextField = new JTextField();
    private final Format infoObjectFormat;
    private final BindingTableModel bindingModel = new BindingTableModel();
    private MediaBindingBean sample = null;
    private boolean submit = false;
    protected final Action mediaInfoAction = new AbstractAction("Open MediaInfo", ResourceManager.getIcon("action.properties")){

        private Map<MediaInfo.StreamKind, List<Map<String, String>>> getMediaInfo(File file) {
            try {
                return MediaInfo.snapshot(file);
            }
            catch (Exception e) {
                Logging.log.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Map<MediaInfo.StreamKind, List<Map<String, String>>> mediaInfo = this.getMediaInfo(BindingDialog.this.getMediaFile());
            if (mediaInfo == null) {
                return;
            }
            JTabbedPane tabbedPane = new JTabbedPane();
            ResourceBundle bundle = ResourceBundle.getBundle(BindingDialog.class.getName());
            RowFilter excludeRowFilter = RowFilter.notFilter(RowFilter.regexFilter(bundle.getString("parameter.exclude"), new int[0]));
            for (MediaInfo.StreamKind streamKind : mediaInfo.keySet()) {
                for (Map<String, String> parameters : mediaInfo.get((Object)streamKind)) {
                    JPanel panel = new JPanel(new MigLayout("fill"));
                    panel.setOpaque(false);
                    JTable table = new JTable(new ParameterTableModel(parameters));
                    table.setAutoCreateRowSorter(true);
                    table.setAutoCreateColumnsFromModel(true);
                    table.setFillsViewportHeight(true);
                    table.setAutoResizeMode(2);
                    table.setSelectionMode(2);
                    table.setBackground(Color.white);
                    table.setGridColor(new Color(0xEEEEEE));
                    table.setRowHeight(25);
                    TableRowSorter sorter = (TableRowSorter)table.getRowSorter();
                    sorter.setRowFilter(excludeRowFilter);
                    panel.add((Component)new JScrollPane(table), "grow");
                    tabbedPane.addTab(streamKind.toString(), panel);
                }
            }
            JDialog dialog = new JDialog(SwingUI.getWindow(evt.getSource()), "MediaInfo", Dialog.ModalityType.DOCUMENT_MODAL);
            JComponent c = (JComponent)dialog.getContentPane();
            c.setLayout(new MigLayout("fill, novisualpadding", "[align center]", "[fill][pref!]"));
            c.add((Component)tabbedPane, "grow, wrap");
            c.add((Component)SwingUI.newButton("OK", e -> dialog.setVisible(false)), "w 80px!, h 25px!");
            dialog.pack();
            dialog.setLocationRelativeTo(BindingDialog.this);
            dialog.setVisible(true);
        }
    };
    protected final Action selectFileAction = new AbstractAction("Select Media File", ResourceManager.getIcon("action.load")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            FileUtilities.ExtensionFileFilter mediaFiles = FileUtilities.ExtensionFileFilter.union(MediaTypes.VIDEO_FILES, MediaTypes.AUDIO_FILES, MediaTypes.SUBTITLE_FILES, MediaTypes.IMAGE_FILES);
            List<File> selection = UserFiles.showLoadDialogSelectFiles(false, false, BindingDialog.this.getMediaFile(), mediaFiles, (String)this.getValue("Name"), evt);
            if (selection.size() > 0) {
                File file = selection.get(0).getAbsoluteFile();
                Object info = XattrMetaInfo.xattr.getMetaInfo(file);
                if (info == null || BindingDialog.this.infoObjectFormat.format(info) == null) {
                    info = BindingDialog.this.getInfoObject();
                }
                BindingDialog.this.setSample(new MediaBindingBean(info, file));
            }
        }
    };

    public BindingDialog(Window owner, String title, Format infoObjectFormat, boolean editable) {
        super(owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.infoObjectFormat = infoObjectFormat;
        JComponent root = (JComponent)this.getContentPane();
        root.setLayout(new MigLayout("nogrid, novisualpadding, fill, insets dialog", "", "[pref!]paragraph[pref!]2px[grow,fill]paragraph[pref!]"));
        JTabbedPane inputContainer = new JTabbedPane();
        inputContainer.setFocusable(false);
        JPanel inputPanel = new JPanel(new MigLayout("nogrid, fill"));
        inputPanel.setOpaque(false);
        inputPanel.add((Component)new JLabel("Info Object:"), "wrap 2px");
        inputPanel.add((Component)this.infoTextField, "hmin 20px, growx, wrap paragraph");
        inputPanel.add((Component)new JLabel("Media File:"), "wrap 2px");
        inputPanel.add((Component)this.mediaFileTextField, "hmin 20px, growx");
        inputPanel.add((Component)SwingUI.createImageButton(this.mediaInfoAction), "gap rel, w 28px!, h 28px!");
        inputPanel.add((Component)SwingUI.createImageButton(this.selectFileAction), "gap rel, w 28px!, h 28px!, wrap paragraph");
        inputContainer.add("Bindings", inputPanel);
        root.add((Component)inputContainer, "growx, wrap");
        root.add((Component)new JLabel("Preview:"), "gap 5px, wrap");
        root.add((Component)new JScrollPane(this.createBindingTable(this.bindingModel)), "grow, growprio 200, wrap");
        if (editable) {
            root.add((Component)SwingUI.newButton("Use Bindings", ResourceManager.getIcon("dialog.continue"), evt -> this.finish(true)), "tag apply");
            root.add((Component)SwingUI.newButton("Cancel", ResourceManager.getIcon("dialog.cancel"), evt -> this.finish(false)), "tag cancel");
        } else {
            root.add((Component)SwingUI.newButton("Close", ResourceManager.getIcon("dialog.continue"), e -> this.finish(false)), "tag ok");
        }
        this.infoTextField.setEditable(false);
        this.mediaFileTextField.setEditable(false);
        this.mediaInfoAction.setEnabled(false);
        this.selectFileAction.setEnabled(editable);
        this.addWindowListener(SwingUI.windowClosed(evt -> this.finish(false)));
        this.setDefaultCloseOperation(0);
        this.setSize(420, 520);
    }

    private JTable createBindingTable(TableModel model) {
        JTable table = new JTable(model);
        table.setAutoCreateRowSorter(true);
        table.setAutoCreateColumnsFromModel(true);
        table.setFillsViewportHeight(true);
        table.setBackground(Color.white);
        table.setDefaultRenderer(Future.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                block4: {
                    super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
                    Future future = (Future)value;
                    this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                    try {
                        this.setText((String)future.get(0L, TimeUnit.MILLISECONDS));
                    }
                    catch (TimeoutException e) {
                        this.setText("Pending \u2026");
                        if (!isSelected) {
                            this.setForeground(new Color(6591981));
                        }
                    }
                    catch (Exception e) {
                        this.setText("undefined");
                        if (isSelected) break block4;
                        this.setForeground(Color.gray);
                    }
                }
                return this;
            }
        });
        return table;
    }

    public boolean submit() {
        return this.submit;
    }

    private void finish(boolean submit) {
        this.submit = submit;
        this.bindingModel.executor.shutdownNow();
        this.setVisible(false);
        this.dispose();
    }

    public void setSample(MediaBindingBean sample) {
        this.sample = sample;
        Object i = this.getInfoObject();
        if (i != null) {
            this.infoTextField.setText(this.infoObjectFormat.format(i));
            this.infoTextField.setToolTipText("<html><pre>" + SwingUI.escapeHTML(JsonUtilities.json(i, true)) + "</pre></html>");
            this.infoTextField.setEnabled(true);
        } else {
            this.infoTextField.setText("none");
            this.infoTextField.setToolTipText("null");
            this.infoTextField.setEnabled(false);
        }
        File f = this.getMediaFile();
        if (f != null) {
            this.mediaFileTextField.setText(f.getPath());
            this.mediaFileTextField.setEnabled(true);
            this.mediaInfoAction.setEnabled(true);
        } else {
            this.mediaFileTextField.setText("none");
            this.mediaFileTextField.setEnabled(false);
            this.mediaInfoAction.setEnabled(false);
        }
        this.updatePreviewModel();
    }

    public MediaBindingBean getSample() {
        return this.sample;
    }

    public Object getInfoObject() {
        return this.sample == null ? null : this.sample.getInfoObject();
    }

    public File getMediaFile() {
        return this.sample == null ? null : this.sample.getFileObject();
    }

    private void updatePreviewModel() {
        if (this.sample == null || this.bindingModel.executor.isShutdown()) {
            return;
        }
        String[] expressions = RegularExpressions.COMMA.split(ResourceBundle.getBundle(this.getClass().getName()).getString("expressions"));
        this.bindingModel.setModel(Arrays.asList(expressions), this.sample);
    }

    private static class ParameterTableModel
    extends AbstractTableModel {
        private final List<Map.Entry<?, ?>> data;

        public ParameterTableModel(Map<?, ?> data) {
            this.data = new ArrayList(data.entrySet());
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Parameter";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.data.get(row).getKey();
                }
                case 1: {
                    return this.data.get(row).getValue();
                }
            }
            return null;
        }
    }

    private static class BindingTableModel
    extends AbstractTableModel {
        private final List<Evaluator> model = new ArrayList<Evaluator>();
        private final ExecutorService executor = Executors.newFixedThreadPool(1, new DefaultThreadFactory("Evaluator", 1));

        private BindingTableModel() {
        }

        public void setModel(Collection<String> expressions, Object bindingBean) {
            this.clear();
            for (String expression : expressions) {
                Evaluator evaluator = new Evaluator(expression, bindingBean){

                    @Override
                    protected void done() {
                        this.fireTableCellUpdated(this);
                    }
                };
                this.executor.execute(evaluator);
                this.model.add(evaluator);
            }
            this.fireTableDataChanged();
        }

        public void clear() {
            for (Evaluator evaluator : this.model) {
                evaluator.cancel(true);
            }
            this.model.clear();
            this.fireTableDataChanged();
        }

        public void fireTableCellUpdated(Evaluator element) {
            int index = this.model.indexOf(element);
            if (index >= 0) {
                this.fireTableCellUpdated(index, 1);
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Expression";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Future.class;
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.model.get(row).getExpression();
                }
                case 1: {
                    return this.model.get(row);
                }
            }
            return null;
        }
    }

    private static class Evaluator
    extends SwingWorker<String, Void> {
        private final String expression;
        private final Object bindingBean;

        private Evaluator(String expression, Object bindingBean) {
            this.expression = expression;
            this.bindingBean = bindingBean;
        }

        public String getExpression() {
            return this.expression;
        }

        @Override
        protected String doInBackground() throws Exception {
            ExpressionFormat format = new ExpressionFormat(this.expression){

                @Override
                protected Object[] compile(String expression) throws ScriptException {
                    return new Object[]{1.compileScriptlet(expression)};
                }
            };
            return format.format(this.bindingBean);
        }

        public String toString() {
            try {
                return (String)this.get(0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

