/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.MediaTypes;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.media.MediaDetection;
import net.filebot.similarity.CommonSequenceMatcher;
import net.filebot.similarity.EpisodeMatcher;
import net.filebot.similarity.Match;
import net.filebot.similarity.Normalization;
import net.filebot.ui.SelectDialog;
import net.filebot.ui.rename.AutoCompleteMatcher;
import net.filebot.ui.rename.OriginalOrder;
import net.filebot.ui.rename.TextColorizer;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.util.ui.SwingUI;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.SearchResult;
import net.filebot.web.SortOrder;

class EpisodeListMatcher
implements AutoCompleteMatcher {
    private EpisodeListProvider provider;
    private boolean anime;
    private Map<String, SearchResult> selectionMemory = new TreeMap<Object, SearchResult>(CommonSequenceMatcher.getLenientCollator(Locale.ENGLISH));
    private Map<String, List<String>> inputMemory = new TreeMap<Object, List<String>>(CommonSequenceMatcher.getLenientCollator(Locale.ENGLISH));

    public EpisodeListMatcher(EpisodeListProvider provider, boolean anime) {
        this.provider = provider;
        this.anime = anime;
    }

    public Cache.TypedCache<SearchResult> getPersistentSelectionMemory() {
        return Cache.getCache("selection_" + this.provider.getName(), CacheType.Persistent).cast(SearchResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Match<File, ?>> match(Collection<File> files, boolean strict, SortOrder sortOrder, Locale locale, boolean autodetection, Component parent) throws Exception {
        if (files.isEmpty()) {
            return this.justFetchEpisodeList(sortOrder, locale, parent);
        }
        ArrayList<File> fileset = autodetection ? FileUtilities.filter(files, FileUtilities.not(MediaDetection.getClutterFileFilter())) : new ArrayList<File>(files);
        List<File> mediaFiles = FileUtilities.filter(fileset, MediaTypes.VIDEO_FILES, MediaTypes.SUBTITLE_FILES);
        ArrayList matches = new ArrayList();
        ExecutorService workerThreadPool = Executors.newFixedThreadPool(Settings.getPreferredThreadPoolSize());
        try {
            ArrayList tasks = new ArrayList();
            if (strict) {
                mediaFiles.stream().filter(f -> MediaDetection.isEpisode(f, false)).map(f -> workerThreadPool.submit(() -> this.matchEpisodeSet(Collections.singletonList(f), MediaDetection.detectSeriesNames(Collections.singleton(f), this.anime, locale), sortOrder, strict, locale, autodetection, parent))).forEach(tasks::add);
            } else {
                MediaDetection.mapSeriesNamesByFiles(mediaFiles, locale, this.anime).forEach((f, n) -> {
                    Collection<List<File>> batches = n != null && n.size() > 0 ? Collections.singleton(new ArrayList(f)) : FileUtilities.mapByFolder(f).values();
                    batches.stream().map(b -> workerThreadPool.submit(() -> this.matchEpisodeSet((List<File>)b, (Collection<String>)n, sortOrder, strict, locale, autodetection, parent))).forEach(tasks::add);
                });
            }
            for (Future future : tasks) {
                for (Match it : (List)future.get()) {
                    matches.add(new Match<File, Episode>((File)it.getValue(), ((Episode)it.getCandidate()).clone()));
                }
            }
        }
        finally {
            workerThreadPool.shutdownNow();
        }
        ArrayList<Match<File, Episode>> derivateMatches = new ArrayList<Match<File, Episode>>();
        TreeSet<File> derivateFiles = new TreeSet<File>(fileset);
        derivateFiles.removeAll(mediaFiles);
        block5: for (File file : derivateFiles) {
            for (Match match : matches) {
                if (!file.getPath().startsWith(((File)match.getValue()).getParentFile().getPath()) || !FileUtilities.isDerived(file, (File)match.getValue()) || !(match.getCandidate() instanceof Episode)) continue;
                derivateMatches.add(new Match<File, Episode>(file, ((Episode)match.getCandidate()).clone()));
                continue block5;
            }
        }
        matches.addAll(derivateMatches);
        matches.sort(Comparator.comparing(Match::getValue, OriginalOrder.of(files)));
        return matches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Match<File, ?>> matchEpisodeSet(List<File> files, Collection<String> queries, SortOrder sortOrder, boolean strict, Locale locale, boolean autodetection, Component parent) throws Exception {
        Set<Episode> episodes = Collections.emptySet();
        if (autodetection && queries != null && queries.size() > 0) {
            episodes = this.fetchEpisodeSet(files, queries, sortOrder, locale, autodetection, parent);
        }
        if (episodes.isEmpty() && !strict) {
            List<String> detectedSeriesNames = MediaDetection.detectSeriesNames(files, this.anime, locale);
            String suggestion = detectedSeriesNames.size() > 0 ? StringUtilities.join(detectedSeriesNames, (CharSequence)"; ") : Normalization.normalizePunctuation(FileUtilities.getName(files.get(0)));
            Map<String, List<String>> map = this.inputMemory;
            synchronized (map) {
                List<String> input = this.inputMemory.get(suggestion);
                if (input == null || suggestion == null || suggestion.isEmpty()) {
                    Component component = parent;
                    synchronized (component) {
                        input = SwingUI.showMultiValueInputDialog(this.getQueryInputMessage("Please identify the following files:", "Enter series name:", files), suggestion, this.provider.getName(), parent);
                    }
                    this.inputMemory.put(suggestion, input);
                }
                if (input != null && input.size() > 0) {
                    episodes = this.fetchEpisodeSet(files, input, sortOrder, locale, false, parent);
                }
            }
        }
        ArrayList matches = new ArrayList();
        if (episodes.size() > 0) {
            for (List<File> filesPerType : MediaDetection.mapByMediaExtension(files).values()) {
                EpisodeMatcher matcher = new EpisodeMatcher(filesPerType, episodes, strict);
                for (Match match : matcher.match()) {
                    if (strict && !MediaDetection.isEpisodeNumberMatch((File)match.getValue(), (Episode)match.getCandidate())) continue;
                    matches.add(new Match<File, Episode>((File)match.getValue(), ((Episode)match.getCandidate()).clone()));
                }
            }
        }
        return matches;
    }

    protected Set<Episode> fetchEpisodeSet(List<File> files, Collection<String> querySet, SortOrder sortOrder, Locale locale, boolean autodetection, Component parent) throws Exception {
        List tasks = querySet.stream().map(q -> WebServices.requestThreadPool.submit(() -> {
            SearchResult selectedSearchResult;
            List<SearchResult> options = this.provider.search((String)q, locale);
            if (options.size() > 0 && (selectedSearchResult = this.selectSearchResult(files, (String)q, options, autodetection, parent)) != null) {
                return this.provider.getEpisodeList(selectedSearchResult, sortOrder, locale);
            }
            return Collections.EMPTY_LIST;
        })).collect(Collectors.toList());
        LinkedHashSet<Episode> episodes = new LinkedHashSet<Episode>();
        for (Future it : tasks) {
            episodes.addAll((Collection)it.get());
        }
        return episodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResult selectSearchResult(List<File> files, String query, List<SearchResult> options, boolean autodetection, Component parent) throws Exception {
        if (options.size() == 1) {
            return options.get(0);
        }
        List<SearchResult> probableMatches = MediaDetection.getProbableMatches(query, options, true, true);
        if (probableMatches.size() == 1) {
            return probableMatches.get(0);
        }
        FutureTask<SearchResult> showSelectDialog = new FutureTask<SearchResult>(() -> {
            JLabel header = new JLabel(this.getQueryInputMessage("Failed to identify some of the following files:", null, this.getFilesForQuery(files, query)));
            header.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            SelectDialog selectDialog = new SelectDialog(parent, options, true, false, header.getText().isEmpty() ? null : header);
            selectDialog.setTitle(this.provider.getName());
            selectDialog.getMessageLabel().setText("<html>Select best match for \"<b>" + SwingUI.escapeHTML(query) + "</b>\":</html>");
            selectDialog.getCancelAction().putValue("Name", "Skip");
            selectDialog.pack();
            selectDialog.restoreState(Preferences.userNodeForPackage(EpisodeListMatcher.class));
            selectDialog.setLocation(SwingUI.getOffsetLocation(selectDialog.getOwner()));
            selectDialog.setVisible(true);
            selectDialog.saveState(Preferences.userNodeForPackage(EpisodeListMatcher.class));
            if (selectDialog.getSelectedAction() == null) {
                throw new CancellationException();
            }
            if (selectDialog.getAutoRepeatCheckBox().isSelected() && selectDialog.getSelectedValue() != null) {
                this.getPersistentSelectionMemory().put(query, selectDialog.getSelectedValue());
            }
            return (SearchResult)selectDialog.getSelectedValue();
        });
        Map<String, SearchResult> map = this.selectionMemory;
        synchronized (map) {
            SearchResult persistentSelection;
            if (this.selectionMemory.containsKey(query)) {
                return this.selectionMemory.get(query);
            }
            if (autodetection && (persistentSelection = this.getPersistentSelectionMemory().get(query)) != null) {
                return persistentSelection;
            }
            Component component = parent;
            synchronized (component) {
                SwingUtilities.invokeAndWait(showSelectDialog);
                SearchResult userSelection = (SearchResult)showSelectDialog.get();
                this.selectionMemory.put(query, userSelection);
                return userSelection;
            }
        }
    }

    protected Collection<File> getFilesForQuery(Collection<File> files, String query) {
        Pattern pattern = Pattern.compile(query.isEmpty() ? ".+" : Normalization.normalizePunctuation(query).replaceAll("\\W+", ".+"), 258);
        List selection = files.stream().filter(f -> StringUtilities.find(f.getPath(), pattern)).collect(Collectors.toList());
        return selection.size() > 0 ? selection : files;
    }

    protected String getQueryInputMessage(String header, String message, Collection<File> files) throws Exception {
        List selection = files.stream().sorted(Comparator.comparing(File::length).reversed()).limit(4L).sorted(FileUtilities.HUMAN_NAME_ORDER).collect(Collectors.toList());
        if (selection.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder(512);
        html.append("<html>");
        if (header != null) {
            html.append(SwingUI.escapeHTML(header)).append("<br>");
        }
        TextColorizer colorizer = new TextColorizer("<nobr>\u2022 ", "</nobr><br>");
        for (File file : selection) {
            File path = MediaDetection.getStructurePathTail(file);
            if (path == null) {
                path = FileUtilities.getRelativePathTail(file, 3);
            }
            colorizer.colorizePath(html, path, true);
        }
        if (selection.size() < files.size()) {
            html.append("\u2022 ").append("\u2026").append("<br>");
        }
        html.append("<br>");
        if (message != null) {
            html.append(SwingUI.escapeHTML(message));
        }
        html.append("</html>");
        return html.toString();
    }

    public List<Match<File, ?>> justFetchEpisodeList(SortOrder sortOrder, Locale locale, Component parent) throws Exception {
        List<String> input = SwingUI.showMultiValueInputDialog("Enter series name:", "", "Fetch Episode List", parent);
        ArrayList matches = new ArrayList();
        if (input.size() > 0) {
            Set<Episode> episodes = this.fetchEpisodeSet(Collections.emptyList(), input, sortOrder, locale, false, parent);
            for (Episode it : episodes) {
                matches.add(new Match<Object, Episode>(null, it));
            }
        }
        return matches;
    }
}

