/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import net.filebot.Logging;
import net.filebot.util.ui.AbstractFancyListCellRenderer;
import net.filebot.util.ui.SwingUI;

class HighlightListCellRenderer
extends AbstractFancyListCellRenderer {
    protected final JTextComponent textComponent = new JTextField();
    protected final Pattern pattern;
    protected final Highlighter.HighlightPainter highlightPainter;

    public HighlightListCellRenderer(Pattern pattern, Highlighter.HighlightPainter highlightPainter, int padding) {
        super(new Insets(0, 0, 0, 0));
        this.pattern = pattern;
        this.highlightPainter = highlightPainter;
        this.textComponent.setBorder(new EmptyBorder(padding, padding, padding, padding));
        this.textComponent.setBackground(SwingUI.TRANSLUCENT);
        this.add((Component)this.textComponent, "West");
        this.textComponent.getDocument().addDocumentListener(new HighlightUpdateListener());
    }

    @Override
    protected void configureListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.configureListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.textComponent.setText(value.toString());
    }

    protected void updateHighlighter() {
        this.textComponent.getHighlighter().removeAllHighlights();
        Matcher matcher = this.pattern.matcher(this.textComponent.getText());
        while (matcher.find()) {
            try {
                this.textComponent.getHighlighter().addHighlight(matcher.start(0), matcher.end(0), this.highlightPainter);
            }
            catch (BadLocationException e) {
                Logging.debug.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.textComponent != null) {
            this.textComponent.setForeground(fg);
        }
    }

    private class HighlightUpdateListener
    implements DocumentListener {
        private HighlightUpdateListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            HighlightListCellRenderer.this.updateHighlighter();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            HighlightListCellRenderer.this.updateHighlighter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            HighlightListCellRenderer.this.updateHighlighter();
        }
    }
}

