/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.rename;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.filebot.ui.rename.RenameList;

class ScrollPaneSynchronizer {
    private final RenameList[] components;

    public ScrollPaneSynchronizer(RenameList ... components) {
        this.components = components;
        BoundedRangeModel horizontalScrollBarModel = components[0].getListScrollPane().getHorizontalScrollBar().getModel();
        BoundedRangeModel verticalScrollBarModel = components[0].getListScrollPane().getVerticalScrollBar().getModel();
        ListDataListener resizeListener = new ListDataListener(){
            private final Timer timer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScrollPaneSynchronizer.this.updatePreferredSize();
                    timer.stop();
                }
            });

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.timer.restart();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.timer.restart();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.timer.restart();
            }
        };
        for (RenameList component : components) {
            component.getListScrollPane().getHorizontalScrollBar().setModel(horizontalScrollBarModel);
            component.getListScrollPane().getVerticalScrollBar().setModel(verticalScrollBarModel);
            component.getListComponent().getModel().addListDataListener(resizeListener);
        }
        this.updatePreferredSize();
    }

    public void updatePreferredSize() {
        Dimension max = new Dimension();
        for (RenameList component : this.components) {
            component.getListComponent().setPreferredSize(null);
            Dimension preferred = component.getListComponent().getPreferredSize();
            if (preferred.width > max.width) {
                max.width = preferred.width;
            }
            if (preferred.height <= max.height) continue;
            max.height = preferred.height;
        }
        for (RenameList component : this.components) {
            component.getListComponent().setPreferredSize(max);
            component.getListComponent().revalidate();
            component.getListScrollPane().revalidate();
        }
    }
}

