/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.filebot.ResourceManager;
import net.filebot.hash.HashType;
import net.filebot.ui.SelectDialog;
import net.filebot.ui.sfv.ChecksumButton;
import net.filebot.ui.sfv.ChecksumCell;
import net.filebot.ui.sfv.ChecksumComputationService;
import net.filebot.ui.sfv.ChecksumComputationTask;
import net.filebot.ui.sfv.ChecksumRow;
import net.filebot.ui.sfv.ChecksumTable;
import net.filebot.ui.sfv.ChecksumTableExportHandler;
import net.filebot.ui.sfv.ChecksumTableModel;
import net.filebot.ui.sfv.ChecksumTableTransferablePolicy;
import net.filebot.ui.sfv.TotalProgressPanel;
import net.filebot.ui.transfer.DefaultTransferHandler;
import net.filebot.ui.transfer.LoadAction;
import net.filebot.ui.transfer.SaveAction;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.SwingUI;
import net.miginfocom.swing.MigLayout;

public class SfvPanel
extends JComponent {
    private final ChecksumComputationService computationService = new ChecksumComputationService();
    private final ChecksumTable table = new ChecksumTable();
    private final ChecksumTableTransferablePolicy transferablePolicy = new ChecksumTableTransferablePolicy(this.table, this.computationService);
    private final ChecksumTableExportHandler exportHandler = new ChecksumTableExportHandler(this.table.getModel());
    private final SaveAction saveAction = new ChecksumTableSaveAction();
    private final LoadAction loadAction = new LoadAction(this::getTransferablePolicy);
    private final AbstractAction clearAction = new AbstractAction("Clear", ResourceManager.getIcon("action.clear")){

        @Override
        public void actionPerformed(ActionEvent e) {
            SfvPanel.this.transferablePolicy.reset();
            SfvPanel.this.computationService.reset();
            SfvPanel.this.table.getModel().clear();
        }
    };
    private final AbstractAction removeAction = new AbstractAction("Remove"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SfvPanel.this.table.getSelectedRowCount() < 1) {
                return;
            }
            int[] rows = SfvPanel.this.table.getSelectedRows();
            if (rows.length <= 0) {
                return;
            }
            int selectedRow = SfvPanel.this.table.getSelectedRow();
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = SfvPanel.this.table.getRowSorter().convertRowIndexToModel(rows[i]);
            }
            SfvPanel.this.table.getModel().remove(rows);
            SfvPanel.this.computationService.purge();
            selectedRow = Math.min(selectedRow, SfvPanel.this.table.getRowCount() - 1);
            SfvPanel.this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
    };

    public SfvPanel() {
        this.table.setTransferHandler(new DefaultTransferHandler(this.transferablePolicy, this.exportHandler));
        JPanel contentPane = new JPanel(new MigLayout("insets 0, nogrid, novisualpadding, fill", "", "[fill]10px[bottom, pref!]4px"));
        contentPane.setBorder(new TitledBorder("SFV"));
        this.setLayout(new MigLayout("insets dialog, fill"));
        this.add((Component)contentPane, "grow");
        contentPane.add((Component)new JScrollPane(this.table), "grow, wrap");
        contentPane.add((Component)new JButton(this.loadAction), "gap left 15px");
        contentPane.add(new JButton(this.saveAction));
        contentPane.add((Component)new JButton(this.clearAction), "gap right 40px");
        ButtonGroup group = new ButtonGroup();
        for (HashType hash : HashType.values()) {
            ChecksumButton button = new ChecksumButton(new ChangeHashTypeAction(hash));
            group.add(button);
            contentPane.add(button);
        }
        contentPane.add((Component)new TotalProgressPanel(this.computationService), "gap left 35px:push, gap right 7px, hidemode 1");
        this.table.getModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("hashType".equals(evt.getPropertyName())) {
                    SfvPanel.this.restartComputation((HashType)((Object)evt.getNewValue()));
                }
            }
        });
        SwingUI.installAction(this, KeyStroke.getKeyStroke(127, 0), this.removeAction);
    }

    public TransferablePolicy getTransferablePolicy() {
        return this.transferablePolicy;
    }

    protected void restartComputation(HashType hash) {
        this.computationService.reset();
        ChecksumTableModel model = this.table.getModel();
        HashMap<File, ExecutorService> executors = new HashMap<File, ExecutorService>(4);
        for (ChecksumRow row : model.rows()) {
            for (ChecksumCell cell : row.values()) {
                if (cell.getChecksum(hash) != null || !cell.getRoot().isDirectory()) continue;
                cell.putTask(new ChecksumComputationTask(new File(cell.getRoot(), cell.getName()), hash));
                ExecutorService executor = (ExecutorService)executors.get(cell.getRoot());
                if (executor == null) {
                    executor = this.computationService.newExecutor();
                    executors.put(cell.getRoot(), executor);
                }
                executor.execute(cell.getTask());
            }
        }
        for (ExecutorService executor : executors.values()) {
            executor.shutdown();
        }
    }

    @Subscribe
    public void handle(Transferable transferable) throws Exception {
        TransferablePolicy handler = this.getTransferablePolicy();
        if (handler != null && handler.accept(transferable)) {
            handler.handleTransferable(transferable, TransferablePolicy.TransferAction.PUT);
        }
    }

    protected class ChecksumTableSaveAction
    extends SaveAction {
        private File selectedColumn;

        public ChecksumTableSaveAction() {
            super(SfvPanel.this.exportHandler);
            this.selectedColumn = null;
        }

        @Override
        public ChecksumTableExportHandler getExportHandler() {
            return (ChecksumTableExportHandler)super.getExportHandler();
        }

        @Override
        protected boolean canExport() {
            return this.selectedColumn != null && super.canExport();
        }

        @Override
        protected void export(File file) throws IOException {
            this.getExportHandler().export(file, this.selectedColumn);
        }

        @Override
        protected File getDefaultFile() {
            return new File(this.selectedColumn, FileUtilities.validateFileName(this.getExportHandler().getDefaultFileName(this.selectedColumn)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<File> options = new ArrayList<File>();
            for (File file : SfvPanel.this.table.getModel().getChecksumColumns()) {
                if (!file.isDirectory()) continue;
                options.add(file);
            }
            if (options.isEmpty()) {
                return;
            }
            try {
                if (options.size() == 1) {
                    this.selectedColumn = (File)options.get(0);
                } else if (options.size() > 1) {
                    SelectDialog<File> selectDialog = new SelectDialog<File>((Component)SwingUtilities.getWindowAncestor(SfvPanel.this), options){

                        @Override
                        protected String convertValueToString(Object value) {
                            return FileUtilities.getFolderName((File)value);
                        }
                    };
                    selectDialog.getMessageLabel().setText("Select checksum column:");
                    selectDialog.pack();
                    selectDialog.setLocationRelativeTo(SfvPanel.this);
                    selectDialog.setVisible(true);
                    this.selectedColumn = (File)selectDialog.getSelectedValue();
                }
                if (this.selectedColumn != null) {
                    super.actionPerformed(e);
                }
            }
            finally {
                this.selectedColumn = null;
            }
        }
    }

    protected class ChangeHashTypeAction
    extends AbstractAction
    implements PropertyChangeListener {
        private ChangeHashTypeAction(HashType hash) {
            super(hash.toString());
            this.putValue("hashType", (Object)hash);
            this.propertyChange(new PropertyChangeEvent(this, "hashType", null, (Object)SfvPanel.this.table.getModel().getHashType()));
            SfvPanel.this.transferablePolicy.addPropertyChangeListener(this);
            SfvPanel.this.table.getModel().addPropertyChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SfvPanel.this.table.getModel().setHashType((HashType)((Object)this.getValue("hashType")));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("loading".equals(evt.getPropertyName())) {
                this.setEnabled((Boolean)evt.getNewValue() == false);
            } else if ("hashType".equals(evt.getPropertyName())) {
                this.putValue("SwingSelectedKey", evt.getNewValue() == this.getValue("hashType"));
            }
        }
    }
}

