/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.sfv;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import net.filebot.ui.sfv.ChecksumComputationService;
import net.miginfocom.swing.MigLayout;

class TotalProgressPanel
extends JComponent {
    private final JProgressBar progressBar = new JProgressBar(0, 0);
    private final int millisToSetVisible = 200;
    private final PropertyChangeListener progressListener = new PropertyChangeListener(){
        private static final String SHOW = "show";
        private static final String HIDE = "hide";
        private final DelayedToggle delayed = new DelayedToggle();
        private final ActionListener visibilityActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TotalProgressPanel.this.setVisible(e.getActionCommand() == 1.SHOW);
            }
        };

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int completedTaskCount = this.getComputationService(evt).getCompletedTaskCount();
            int totalTaskCount = this.getComputationService(evt).getTotalTaskCount();
            SwingUtilities.invokeLater(() -> {
                if (completedTaskCount == totalTaskCount) {
                    this.delayed.toggle(HIDE, totalTaskCount == 0 ? 200 : 0, this.visibilityActionHandler);
                } else if (totalTaskCount != 0) {
                    this.delayed.toggle(SHOW, 200, this.visibilityActionHandler);
                }
                if (totalTaskCount != 0) {
                    TotalProgressPanel.this.progressBar.setValue(completedTaskCount);
                    TotalProgressPanel.this.progressBar.setMaximum(totalTaskCount);
                    TotalProgressPanel.this.progressBar.setString(String.format("%d / %d", completedTaskCount, totalTaskCount));
                }
            });
        }

        private ChecksumComputationService getComputationService(PropertyChangeEvent evt) {
            return (ChecksumComputationService)evt.getSource();
        }
    };

    public TotalProgressPanel(ChecksumComputationService computationService) {
        this.setLayout(new MigLayout("insets 1px"));
        this.setBorder(new TitledBorder("Total Progress"));
        this.setVisible(false);
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "growx");
        computationService.addPropertyChangeListener(this.progressListener);
    }

    protected static class DelayedToggle {
        private Timer timer = null;

        protected DelayedToggle() {
        }

        public void toggle(String action, int delay, final ActionListener actionHandler) {
            if (this.timer != null) {
                if (action.equals(this.timer.getActionCommand())) {
                    return;
                }
                this.timer.stop();
            }
            this.timer = new Timer(delay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    actionHandler.actionPerformed(e);
                }
            });
            this.timer.setActionCommand(action);
            this.timer.setRepeats(false);
            this.timer.start();
        }
    }
}

