/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.Settings;
import net.filebot.WebServices;
import net.filebot.platform.mac.MacAppUtilities;
import net.filebot.subtitle.SubtitleMetrics;
import net.filebot.subtitle.SubtitleNaming;
import net.filebot.subtitle.SubtitleUtilities;
import net.filebot.ui.subtitle.SimpleComboBox;
import net.filebot.util.FileUtilities;
import net.filebot.util.ui.AbstractBean;
import net.filebot.util.ui.DashedSeparator;
import net.filebot.util.ui.EmptySelectionModel;
import net.filebot.util.ui.LinkButton;
import net.filebot.util.ui.RoundBorder;
import net.filebot.util.ui.SwingUI;
import net.filebot.vfs.MemoryFile;
import net.filebot.web.SubtitleDescriptor;
import net.filebot.web.SubtitleProvider;
import net.filebot.web.VideoHashSubtitleService;
import net.miginfocom.swing.MigLayout;

class SubtitleAutoMatchDialog
extends JDialog {
    private static final Color hashMatchColor = new Color(16448210);
    private static final Color nameMatchColor = new Color(16772045);
    private final JPanel hashMatcherServicePanel = this.createServicePanel(hashMatchColor);
    private final JPanel nameMatcherServicePanel = this.createServicePanel(nameMatchColor);
    private final List<SubtitleServiceBean> services = new ArrayList<SubtitleServiceBean>();
    private final JTable subtitleMappingTable = this.createTable();
    private final JComboBox<SubtitleNaming> preferredSubtitleNaming = new JComboBox<SubtitleNaming>(SubtitleNaming.values());
    private ExecutorService queryService;
    private ExecutorService downloadService;
    private final Action downloadAction = new AbstractAction("Download", ResourceManager.getIcon("dialog.continue")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SubtitleAutoMatchDialog.this.subtitleMappingTable.getCellEditor() != null) {
                SubtitleAutoMatchDialog.this.subtitleMappingTable.getCellEditor().stopCellEditing();
            }
            if (SubtitleAutoMatchDialog.this.downloadService != null && !SubtitleAutoMatchDialog.this.downloadService.isTerminated()) {
                return;
            }
            SubtitleMappingTableModel mappingModel = (SubtitleMappingTableModel)SubtitleAutoMatchDialog.this.subtitleMappingTable.getModel();
            if (Settings.isMacSandbox()) {
                MacAppUtilities.askUnlockFolders(SwingUI.getWindow(evt.getSource()), mappingModel.getVideoFiles());
            }
            ArrayList<1> downloadQueue = new ArrayList<1>();
            for (final SubtitleMapping mapping : mappingModel) {
                SubtitleDescriptorBean subtitleBean = mapping.getSelectedOption();
                if (subtitleBean == null || subtitleBean.getState() != null) continue;
                downloadQueue.add(new DownloadTask(mapping.getVideoFile(), subtitleBean, (SubtitleNaming)((Object)SubtitleAutoMatchDialog.this.preferredSubtitleNaming.getSelectedItem())){

                    @Override
                    protected void done() {
                        try {
                            mapping.setSubtitleFile((File)this.get());
                        }
                        catch (Exception e) {
                            Logging.debug.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                });
            }
            ArrayList<DownloadTask> confirmReplaceDownloadQueue = new ArrayList<DownloadTask>();
            ArrayList<String> existingFiles = new ArrayList<String>();
            for (DownloadTask downloadTask : downloadQueue) {
                File target = downloadTask.getDestination(null);
                if (target == null || !target.exists()) continue;
                confirmReplaceDownloadQueue.add(downloadTask);
                existingFiles.add(target.getName());
            }
            if (confirmReplaceDownloadQueue.size() > 0) {
                Boolean option = SubtitleAutoMatchDialog.this.showConfirmReplaceDialog(existingFiles);
                if (option == null) {
                    return;
                }
                if (!option.booleanValue()) {
                    downloadQueue.removeAll(confirmReplaceDownloadQueue);
                }
            }
            if (downloadQueue.size() > 0) {
                SubtitleAutoMatchDialog.this.downloadService = Executors.newSingleThreadExecutor();
                for (DownloadTask downloadTask : downloadQueue) {
                    downloadTask.getSubtitleBean().setState(SwingWorker.StateValue.PENDING);
                    SubtitleAutoMatchDialog.this.downloadService.execute(downloadTask);
                }
                SubtitleAutoMatchDialog.this.downloadService.shutdown();
            }
        }
    };
    private final Action finishAction = new AbstractAction("Close", ResourceManager.getIcon("dialog.cancel")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SubtitleAutoMatchDialog.this.queryService != null) {
                SubtitleAutoMatchDialog.this.queryService.shutdownNow();
            }
            if (SubtitleAutoMatchDialog.this.downloadService != null) {
                SubtitleAutoMatchDialog.this.downloadService.shutdownNow();
            }
            SubtitleAutoMatchDialog.this.setVisible(false);
            SubtitleAutoMatchDialog.this.dispose();
        }
    };

    public SubtitleAutoMatchDialog(Window owner) {
        super(owner, "Download Subtitles", Dialog.ModalityType.DOCUMENT_MODAL);
        this.preferredSubtitleNaming.setSelectedItem((Object)SubtitleNaming.MATCH_VIDEO_ADD_LANGUAGE_TAG);
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new MigLayout("fill, insets 12 15 7 15, nogrid, novisualpadding", "", "[fill][pref!]"));
        content.add((Component)new JScrollPane(this.subtitleMappingTable), "grow, wrap");
        content.add((Component)this.hashMatcherServicePanel, "gap after rel");
        content.add((Component)this.nameMatcherServicePanel, "gap after indent*2");
        this.preferredSubtitleNaming.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Subtitle Naming"), this.preferredSubtitleNaming.getBorder()));
        content.add((Component)new JLabel(), "grow");
        content.add(this.preferredSubtitleNaming, "gap after indent*2");
        content.add((Component)new JButton(this.downloadAction), "tag ok");
        content.add((Component)new JButton(this.finishAction), "tag cancel");
    }

    protected JPanel createServicePanel(Color color) {
        JPanel panel = new JPanel(new MigLayout("hidemode 3, novisualpadding"));
        panel.setBorder(new RoundBorder());
        panel.setOpaque(false);
        panel.setBackground(color);
        panel.setVisible(false);
        return panel;
    }

    protected JTable createTable() {
        JTable table = new JTable(new SubtitleMappingTableModel(new File[0]));
        table.setDefaultRenderer(SubtitleMapping.class, new SubtitleMappingOptionRenderer());
        table.setRowHeight(24);
        table.setIntercellSpacing(new Dimension(5, 5));
        table.setBackground(Color.white);
        table.setAutoCreateRowSorter(true);
        table.setFillsViewportHeight(true);
        SimpleComboBox editor = new SimpleComboBox(ResourceManager.getIcon("action.select"));
        editor.setRenderer(new SubtitleOptionRenderer(true));
        table.setSelectionModel(new EmptySelectionModel());
        editor.setFocusable(false);
        table.setDefaultEditor(SubtitleMapping.class, new DefaultCellEditor(editor){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JComboBox editor = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                SubtitleMapping mapping = (SubtitleMapping)value;
                DefaultComboBoxModel<SubtitleDescriptorBean> model = new DefaultComboBoxModel<SubtitleDescriptorBean>(mapping.getOptions());
                model.addElement(null);
                editor.setModel(model);
                editor.setSelectedItem(mapping.getSelectedOption());
                return editor;
            }
        });
        return table;
    }

    public void setVideoFiles(File[] videoFiles) {
        this.subtitleMappingTable.setModel(new SubtitleMappingTableModel(videoFiles));
    }

    public void addSubtitleService(VideoHashSubtitleService service) {
        this.addSubtitleService(new VideoHashSubtitleServiceBean(service), this.hashMatcherServicePanel);
    }

    public void addSubtitleService(SubtitleProvider service) {
        this.addSubtitleService(new SubtitleProviderBean(service, this), this.nameMatcherServicePanel);
    }

    protected void addSubtitleService(SubtitleServiceBean service, JPanel servicePanel) {
        LinkButton component = new LinkButton(service.getDescription(), null, ResourceManager.getIcon("database"), service.getLink());
        component.setBorder(BorderFactory.createEmptyBorder());
        component.setVisible(false);
        service.addPropertyChangeListener(evt -> {
            if (service.getState() == SwingWorker.StateValue.STARTED) {
                component.setIcon(ResourceManager.getIcon("database.go"));
            } else {
                component.setIcon(ResourceManager.getIcon(service.getError() == null ? "database.ok" : "database.error"));
            }
            component.setVisible(true);
            component.setToolTipText(String.format("%s: %s", service.getName(), service.getError() == null ? service.getState().toString().toLowerCase() : service.getError().getMessage()));
            servicePanel.setVisible(true);
            servicePanel.getParent().revalidate();
        });
        this.services.add(service);
        servicePanel.add(component);
    }

    public void startQuery(Locale locale) {
        final SubtitleMappingTableModel mappingModel = (SubtitleMappingTableModel)this.subtitleMappingTable.getModel();
        QueryTask queryTask = new QueryTask(this.services, mappingModel.getVideoFiles(), locale, this){

            @Override
            protected void process(List<Map<File, List<SubtitleDescriptorBean>>> sequence) {
                for (Map<File, List<SubtitleDescriptorBean>> subtitles : sequence) {
                    for (SubtitleMapping subtitleMapping : mappingModel) {
                        List<SubtitleDescriptorBean> options = subtitles.get(subtitleMapping.getVideoFile());
                        if (options == null || options.size() <= 0) continue;
                        subtitleMapping.addOptions(options);
                    }
                    if (subtitles.size() <= 0) continue;
                    mappingModel.setOptionColumnVisible(true);
                }
            }

            @Override
            protected void done() {
                SwingUtilities.invokeLater(mappingModel::fireTableStructureChanged);
            }
        };
        this.queryService = Executors.newSingleThreadExecutor();
        this.queryService.submit(queryTask);
    }

    private Boolean showConfirmReplaceDialog(List<?> files) {
        JList existingFilesComponent = new JList(files.toArray()){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(80, 50);
            }
        };
        Object[] message = new Object[]{"Replace existing subtitle files?", new JScrollPane(existingFilesComponent)};
        Object[] options = new Object[]{"Replace All", "Skip All", "Cancel"};
        JOptionPane optionPane = new JOptionPane(message, 2, 1, null, options);
        optionPane.createDialog(this, "Replace").setVisible(true);
        if (options[0] == optionPane.getValue()) {
            return true;
        }
        if (options[1] == optionPane.getValue()) {
            return false;
        }
        return null;
    }

    protected static class SubtitleProviderBean
    extends SubtitleServiceBean {
        private SubtitleProvider service;

        public SubtitleProviderBean(SubtitleProvider service, SubtitleAutoMatchDialog inputProvider) {
            super(service.getName(), service.getIcon(), service.getLink());
            this.service = service;
        }

        @Override
        public String getDescription() {
            return "Fuzzy Search";
        }

        @Override
        protected Map<File, List<SubtitleDescriptor>> getSubtitleList(Collection<File> fileSet, Locale locale, Component parent) throws Exception {
            return SubtitleUtilities.findSubtitlesByName(this.service, fileSet, locale, null, true, false);
        }

        @Override
        public float getMatchProbabilty(File videoFile, SubtitleDescriptor descriptor) {
            return SubtitleMetrics.verificationMetric().getSimilarity(videoFile, descriptor);
        }
    }

    protected static class VideoHashSubtitleServiceBean
    extends SubtitleServiceBean {
        private VideoHashSubtitleService service;

        public VideoHashSubtitleServiceBean(VideoHashSubtitleService service) {
            super(service.getName(), service.getIcon(), service.getLink());
            this.service = service;
        }

        @Override
        public String getDescription() {
            return this.service == WebServices.OpenSubtitles ? "Exact Search" : this.service.getName();
        }

        @Override
        protected Map<File, List<SubtitleDescriptor>> getSubtitleList(Collection<File> files, Locale locale, Component parent) throws Exception {
            return SubtitleUtilities.lookupSubtitlesByHash(this.service, files, locale, true, false);
        }

        @Override
        public float getMatchProbabilty(File videoFile, SubtitleDescriptor descriptor) {
            return 1.0f;
        }
    }

    protected static abstract class SubtitleServiceBean
    extends AbstractBean {
        private final String name;
        private final Icon icon;
        private final URI link;
        private SwingWorker.StateValue state = SwingWorker.StateValue.PENDING;
        private Exception error = null;

        public SubtitleServiceBean(String name, Icon icon, URI link) {
            this.name = name;
            this.icon = icon;
            this.link = link;
        }

        public String getName() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public URI getLink() {
            return this.link;
        }

        public abstract String getDescription();

        public abstract float getMatchProbabilty(File var1, SubtitleDescriptor var2);

        protected abstract Map<File, List<SubtitleDescriptor>> getSubtitleList(Collection<File> var1, Locale var2, Component var3) throws Exception;

        public final Map<File, List<SubtitleDescriptor>> lookupSubtitles(Collection<File> files, Locale locale, Component parent) throws Exception {
            this.setState(SwingWorker.StateValue.STARTED);
            try {
                Map<File, List<SubtitleDescriptor>> map = this.getSubtitleList(files, locale, parent);
                return map;
            }
            catch (Exception e) {
                this.error = e;
                throw this.error;
            }
            finally {
                this.setState(SwingWorker.StateValue.DONE);
            }
        }

        private void setState(SwingWorker.StateValue state) {
            this.state = state;
            this.firePropertyChange("state", null, (Object)this.state);
        }

        public SwingWorker.StateValue getState() {
            return this.state;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    private static class DownloadTask
    extends SwingWorker<File, Void> {
        private final File video;
        private final SubtitleDescriptorBean descriptor;
        private final SubtitleNaming naming;

        public DownloadTask(File video, SubtitleDescriptorBean descriptor, SubtitleNaming naming) {
            this.video = video;
            this.descriptor = descriptor;
            this.naming = naming;
        }

        public SubtitleDescriptorBean getSubtitleBean() {
            return this.descriptor;
        }

        public File getDestination(MemoryFile subtitle) {
            if (this.descriptor.getType() == null && subtitle == null) {
                return null;
            }
            String name = this.naming.format(this.video, this.descriptor.getDescriptor(), this.descriptor.getType());
            return new File(this.video.getParentFile(), name);
        }

        @Override
        protected File doInBackground() {
            try {
                MemoryFile subtitle = this.descriptor.fetch();
                if (this.isCancelled()) {
                    return null;
                }
                File destination = this.getDestination(subtitle);
                FileUtilities.writeFile(subtitle.getData(), destination);
                return destination;
            }
            catch (Exception e) {
                this.descriptor.error = e;
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    private static class QueryTask
    extends SwingWorker<Collection<File>, Map<File, List<SubtitleDescriptorBean>>> {
        private final Component parent;
        private final Collection<SubtitleServiceBean> services;
        private final Collection<File> remainingVideos;
        private final Locale locale;

        public QueryTask(Collection<SubtitleServiceBean> services, Collection<File> videoFiles, Locale locale, Component parent) {
            this.parent = parent;
            this.services = services;
            this.remainingVideos = new TreeSet<File>(videoFiles);
            this.locale = locale;
        }

        @Override
        protected Collection<File> doInBackground() throws Exception {
            for (SubtitleServiceBean service : this.services) {
                if (this.isCancelled() || Thread.interrupted()) {
                    throw new CancellationException();
                }
                if (this.remainingVideos.isEmpty()) break;
                try {
                    HashMap subtitleSet = new HashMap();
                    for (Map.Entry<File, List<SubtitleDescriptor>> entry : service.lookupSubtitles(this.remainingVideos, this.locale, this.parent).entrySet()) {
                        LinkedHashSet<SubtitleDescriptor> subtitlesByRelevance = new LinkedHashSet<SubtitleDescriptor>();
                        SubtitleDescriptor bestMatch = SubtitleUtilities.getBestMatch(entry.getKey(), (Collection<SubtitleDescriptor>)entry.getValue(), false);
                        if (bestMatch != null) {
                            subtitlesByRelevance.add(bestMatch);
                        }
                        subtitlesByRelevance.addAll((Collection)entry.getValue());
                        ArrayList<SubtitleDescriptorBean> subtitles = new ArrayList<SubtitleDescriptorBean>();
                        for (SubtitleDescriptor it : subtitlesByRelevance) {
                            subtitles.add(new SubtitleDescriptorBean(entry.getKey(), it, service));
                        }
                        subtitleSet.put(entry.getKey(), subtitles);
                    }
                    for (Map.Entry<File, List<SubtitleDescriptor>> entry : subtitleSet.entrySet()) {
                        if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
                        this.remainingVideos.remove(entry.getKey());
                    }
                    this.publish(subtitleSet);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return this.remainingVideos;
        }
    }

    private static class SubtitleDescriptorBean
    extends AbstractBean {
        private final File videoFile;
        private final SubtitleDescriptor descriptor;
        private final SubtitleServiceBean service;
        private SwingWorker.StateValue state;
        private Exception error;

        public SubtitleDescriptorBean(File videoFile, SubtitleDescriptor descriptor, SubtitleServiceBean service) {
            this.videoFile = videoFile;
            this.descriptor = descriptor;
            this.service = service;
        }

        public SubtitleDescriptor getDescriptor() {
            return this.descriptor;
        }

        public float getMatchProbability() {
            return this.service.getMatchProbabilty(this.videoFile, this.descriptor);
        }

        public String getText() {
            return SubtitleUtilities.formatSubtitle(this.descriptor.getName(), this.getLanguageName(), this.getType());
        }

        public Icon getIcon() {
            return this.service.getIcon();
        }

        public String getLanguageName() {
            return this.descriptor.getLanguageName();
        }

        public String getType() {
            return this.descriptor.getType();
        }

        public MemoryFile fetch() throws Exception {
            this.setState(SwingWorker.StateValue.STARTED);
            try {
                MemoryFile memoryFile = SubtitleUtilities.fetchSubtitle(this.descriptor);
                return memoryFile;
            }
            catch (Exception e) {
                this.error = e;
                throw this.error;
            }
            finally {
                this.setState(SwingWorker.StateValue.DONE);
            }
        }

        public Exception getError() {
            return this.error;
        }

        public SwingWorker.StateValue getState() {
            return this.state;
        }

        public void setState(SwingWorker.StateValue state) {
            this.state = state;
            this.firePropertyChange("state", null, (Object)this.state);
        }

        public String toString() {
            return this.getText();
        }
    }

    private static class SubtitleMapping
    extends AbstractBean {
        private File videoFile;
        private File subtitleFile;
        private SubtitleDescriptorBean selectedOption;
        private List<SubtitleDescriptorBean> options = new ArrayList<SubtitleDescriptorBean>();
        private final PropertyChangeListener selectedOptionListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.firePropertyChange("selectedOption", null, selectedOption);
            }
        };

        public SubtitleMapping(File videoFile) {
            this.videoFile = videoFile;
        }

        public File getVideoFile() {
            return this.videoFile;
        }

        public File getSubtitleFile() {
            return this.subtitleFile;
        }

        public void setSubtitleFile(File subtitleFile) {
            this.subtitleFile = subtitleFile;
            this.firePropertyChange("subtitleFile", null, this.subtitleFile);
        }

        public boolean isEditable() {
            return this.subtitleFile == null && this.options.size() > 0 && (this.selectedOption == null || this.selectedOption.getState() == null || this.selectedOption.getError() != null);
        }

        public SubtitleDescriptorBean getSelectedOption() {
            return this.selectedOption;
        }

        public void setSelectedOption(SubtitleDescriptorBean selectedOption) {
            if (this.selectedOption != null) {
                this.selectedOption.removePropertyChangeListener(this.selectedOptionListener);
            }
            this.selectedOption = selectedOption;
            if (this.selectedOption != null) {
                this.selectedOption.addPropertyChangeListener(this.selectedOptionListener);
            }
            this.firePropertyChange("selectedOption", null, this.selectedOption);
        }

        public SubtitleDescriptorBean[] getOptions() {
            return this.options.toArray(new SubtitleDescriptorBean[0]);
        }

        public void addOptions(List<SubtitleDescriptorBean> options) {
            this.options.addAll(options);
            if (this.selectedOption == null && options.size() > 0) {
                this.setSelectedOption(options.get(0));
            }
        }
    }

    private static class SubtitleMappingTableModel
    extends AbstractTableModel
    implements Iterable<SubtitleMapping> {
        private final SubtitleMapping[] data;
        private boolean optionColumnVisible = false;

        public SubtitleMappingTableModel(File ... videoFiles) {
            this.data = new SubtitleMapping[videoFiles.length];
            for (int i = 0; i < videoFiles.length; ++i) {
                this.data[i] = new SubtitleMapping(videoFiles[i]);
                this.data[i].addPropertyChangeListener(new SubtitleMappingListener(i));
            }
        }

        public List<File> getVideoFiles() {
            return new AbstractList<File>(){

                @Override
                public File get(int index) {
                    return data[index].getVideoFile();
                }

                @Override
                public int size() {
                    return data.length;
                }
            };
        }

        @Override
        public Iterator<SubtitleMapping> iterator() {
            return Arrays.asList(this.data).iterator();
        }

        public void setOptionColumnVisible(boolean optionColumnVisible) {
            if (this.optionColumnVisible == optionColumnVisible) {
                return;
            }
            this.optionColumnVisible = optionColumnVisible;
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.optionColumnVisible ? 2 : 1;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Video";
                }
                case 1: {
                    return "Subtitle";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.data[row].getVideoFile().getName();
                }
                case 1: {
                    return this.data[row];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            this.data[row].setSelectedOption((SubtitleDescriptorBean)value);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 && this.data[row].isEditable();
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return SubtitleMapping.class;
                }
            }
            return null;
        }

        private class SubtitleMappingListener
        implements PropertyChangeListener {
            private final int index;

            public SubtitleMappingListener(int index) {
                this.index = index;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SubtitleMappingTableModel.this.fireTableRowsUpdated(this.index, this.index);
            }
        }
    }

    private static class SubtitleOptionRenderer
    extends DefaultListCellRenderer {
        private final Border padding = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        private final boolean isEditor;

        public SubtitleOptionRenderer(boolean isEditor) {
            this.isEditor = isEditor;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            this.setBorder(this.padding);
            SubtitleDescriptorBean subtitleBean = (SubtitleDescriptorBean)value;
            if (this.isEditor && index == list.getModel().getSize() - 2) {
                this.setBorder(new CompoundBorder(new DashedSeparator(10, 4, Color.lightGray, list.getBackground()), this.getBorder()));
            }
            if (value == null) {
                this.setText("Cancel selection");
                this.setIcon(ResourceManager.getIcon("dialog.cancel"));
            } else {
                if (subtitleBean.getError() == null) {
                    this.setText(subtitleBean.getText());
                    this.setIcon(subtitleBean.getIcon());
                } else {
                    this.setText(String.format("%s (%s)", subtitleBean.getError(), subtitleBean.getText()));
                    this.setIcon(ResourceManager.getIcon("status.warning"));
                }
                if (!isSelected) {
                    float f = subtitleBean.getMatchProbability();
                    if (f < 1.0f) {
                        this.setOpaque(true);
                        this.setBackground(nameMatchColor);
                    }
                    if (f < 0.9f) {
                        this.setOpaque(true);
                        this.setBackground(SwingUI.derive(Color.RED, (1.0f - f) * 0.5f));
                    }
                }
            }
            return this;
        }
    }

    private static class SubtitleMappingOptionRenderer
    extends DefaultTableCellRenderer {
        private final JComboBox optionComboBox = new SimpleComboBox(ResourceManager.getIcon("action.select"));

        public SubtitleMappingOptionRenderer() {
            this.optionComboBox.setBackground(Color.white);
            this.optionComboBox.setRenderer(new SubtitleOptionRenderer(false));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SubtitleMapping mapping = (SubtitleMapping)value;
            SubtitleDescriptorBean subtitleBean = mapping.getSelectedOption();
            if (mapping.isEditable() && subtitleBean != null) {
                this.optionComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{subtitleBean}));
                return this.optionComboBox;
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setForeground(table.getForeground());
            if (subtitleBean == null) {
                if (mapping.getOptions().length == 0) {
                    this.setText("No subtitles found");
                    this.setIcon(null);
                    this.setForeground(Color.gray);
                } else {
                    this.setText("No subtitles selected");
                    this.setIcon(null);
                    this.setForeground(Color.gray);
                }
            } else if (subtitleBean.getState() == SwingWorker.StateValue.PENDING) {
                this.setText(subtitleBean.getText());
                this.setIcon(ResourceManager.getIcon("worker.pending"));
            } else if (subtitleBean.getState() == SwingWorker.StateValue.STARTED) {
                this.setText(subtitleBean.getText());
                this.setIcon(ResourceManager.getIcon("action.fetch"));
            } else if (mapping.getSubtitleFile() != null) {
                this.setText(mapping.getSubtitleFile().getName());
                this.setIcon(ResourceManager.getIcon("status.ok"));
            } else {
                this.setText(null);
                this.setIcon(null);
            }
            return this;
        }
    }
}

