/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.subtitle;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.CompoundBorder;
import net.filebot.ResourceManager;
import net.filebot.ui.subtitle.SubtitlePackage;
import net.filebot.util.ui.AbstractFancyListCellRenderer;
import net.filebot.util.ui.DashedSeparator;
import net.miginfocom.swing.MigLayout;

class SubtitlePackageCellRenderer
extends AbstractFancyListCellRenderer {
    private final JLabel titleLabel = new JLabel();
    private final JLabel languageLabel = new JLabel();

    public SubtitlePackageCellRenderer() {
        super(new Insets(5, 5, 5, 5));
        this.setHighlightingEnabled(false);
        this.setLayout(new MigLayout("fill, nogrid, insets 0"));
        this.add((Component)this.languageLabel, "hidemode 3, w 85px!");
        this.add(this.titleLabel);
        this.setBorder(new CompoundBorder(new DashedSeparator(2, 4, Color.lightGray, Color.white), this.getBorder()));
    }

    @Override
    public void configureListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.configureListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        SubtitlePackage subtitle = (SubtitlePackage)value;
        this.titleLabel.setText(subtitle.getName());
        this.titleLabel.setIcon(this.getIcon(subtitle));
        if (this.languageLabel.isVisible()) {
            this.languageLabel.setText(subtitle.getLanguage().getName());
            this.languageLabel.setIcon(ResourceManager.getFlagIcon(subtitle.getLanguage().getCode()));
        }
        this.titleLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.languageLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.setBorderPainted(index < list.getModel().getSize() - 1);
    }

    private Icon getIcon(SubtitlePackage subtitle) {
        switch (subtitle.getDownload().getPhase()) {
            case PENDING: {
                return ResourceManager.getIcon("bullet.green");
            }
            case WAITING: {
                return ResourceManager.getIcon("worker.pending");
            }
            case DOWNLOADING: {
                return ResourceManager.getIcon("package.fetch");
            }
            case EXTRACTING: {
                return ResourceManager.getIcon("package.extract");
            }
            case DONE: {
                return ResourceManager.getIcon("status.ok");
            }
        }
        return null;
    }

    public JLabel getLanguageLabel() {
        return this.languageLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }
}

