/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.ui.transfer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.UserFiles;
import net.filebot.ui.transfer.FileTransferable;
import net.filebot.ui.transfer.FileTransferablePolicy;
import net.filebot.ui.transfer.TransferablePolicy;
import net.filebot.util.FileUtilities;

public class LoadAction
extends AbstractAction {
    public final Supplier<TransferablePolicy> handler;

    public LoadAction(Supplier<TransferablePolicy> handler) {
        this("Load", ResourceManager.getIcon("action.load"), handler);
    }

    public LoadAction(String name, Icon icon, Supplier<TransferablePolicy> handler) {
        super(name, icon);
        this.handler = handler;
    }

    public TransferablePolicy.TransferAction getTransferAction(ActionEvent evt) {
        return (evt.getModifiers() & 2) != 0 ? TransferablePolicy.TransferAction.ADD : TransferablePolicy.TransferAction.PUT;
    }

    protected File getDefaultFile() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            TransferablePolicy transferablePolicy = this.handler.get();
            if (transferablePolicy == null) {
                return;
            }
            List<File> files = UserFiles.showLoadDialogSelectFiles(true, true, this.getDefaultFile(), this.getFileFilter(transferablePolicy), (String)this.getValue("Name"), evt);
            if (files.isEmpty()) {
                return;
            }
            FileTransferable transferable = new FileTransferable(files);
            if (transferablePolicy.accept(transferable)) {
                transferablePolicy.handleTransferable(transferable, this.getTransferAction(evt));
            }
        }
        catch (Exception e) {
            Logging.log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected FileUtilities.ExtensionFileFilter getFileFilter(TransferablePolicy transferablePolicy) {
        FileTransferablePolicy ftp;
        if (transferablePolicy instanceof FileTransferablePolicy && (ftp = (FileTransferablePolicy)transferablePolicy).getFileFilterDescription() != null && ftp.getFileFilterExtensions() != null) {
            return new FileUtilities.ExtensionFileFilter(ftp.getFileFilterExtensions()){

                @Override
                public String toString() {
                    return ftp.getFileFilterDescription();
                }
            };
        }
        return null;
    }
}

