/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class AlphanumComparator
implements Comparator<String> {
    protected Collator collator;

    public AlphanumComparator(Collator collator) {
        this.collator = collator;
    }

    public AlphanumComparator(Locale locale) {
        this.collator = Collator.getInstance(locale);
        this.collator.setDecomposition(2);
        this.collator.setStrength(0);
    }

    protected boolean isDigit(String s, int i) {
        return Character.isDigit(s.charAt(i));
    }

    protected int getNumericValue(String s, int i) {
        return Character.getNumericValue(s.charAt(i));
    }

    protected String getChunk(String s, int start) {
        int index = start;
        int length = s.length();
        boolean mode = this.isDigit(s, index++);
        while (index < length && mode == this.isDigit(s, index)) {
            ++index;
        }
        return s.substring(start, index);
    }

    @Override
    public int compare(String s1, String s2) {
        int length1 = s1.length();
        int length2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        int result = 0;
        while (result == 0 && index1 < length1 && index2 < length2) {
            String chunk1 = this.getChunk(s1, index1);
            index1 += chunk1.length();
            String chunk2 = this.getChunk(s2, index2);
            index2 += chunk2.length();
            if (this.isDigit(chunk1, 0) && this.isDigit(chunk2, 0)) {
                int zeroIndex2;
                int zeroIndex1;
                int chunkLength1 = chunk1.length();
                int chunkLength2 = chunk2.length();
                for (zeroIndex1 = 0; zeroIndex1 < chunkLength1 && this.getNumericValue(chunk1, zeroIndex1) == 0; ++zeroIndex1) {
                }
                for (zeroIndex2 = 0; zeroIndex2 < chunkLength2 && this.getNumericValue(chunk2, zeroIndex2) == 0; ++zeroIndex2) {
                }
                result = chunkLength1 - zeroIndex1 - (chunkLength2 - zeroIndex2);
                int numberIndex1 = zeroIndex1;
                int numberIndex2 = zeroIndex2;
                while (result == 0 && numberIndex1 < chunkLength1 && numberIndex2 < chunkLength2) {
                    result = this.getNumericValue(chunk1, numberIndex1++) - this.getNumericValue(chunk2, numberIndex2++);
                }
                if (result != 0) continue;
                result = numberIndex1 - numberIndex2;
                continue;
            }
            result = this.collator.compare(chunk1, chunk2);
        }
        if (result == 0) {
            result = length1 - length2;
        }
        return Integer.signum(result);
    }
}

