/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;
    private final float loadFactor;

    public ByteBufferOutputStream(long initialCapacity) {
        this((int)initialCapacity, 1.0f);
    }

    public ByteBufferOutputStream(int initialCapacity) {
        this(initialCapacity, 1.0f);
    }

    public ByteBufferOutputStream(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must not be negative: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("loadFactor must be greater than zero: " + loadFactor);
        }
        this.buffer = ByteBuffer.allocate(initialCapacity + 1);
        this.loadFactor = loadFactor;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureCapacity(this.buffer.position() + 1);
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] src) throws IOException {
        this.ensureCapacity(this.buffer.position() + src.length);
        this.buffer.put(src);
    }

    public void write(ByteBuffer src) throws IOException {
        this.ensureCapacity(this.buffer.position() + src.remaining());
        this.buffer.put(src);
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this.ensureCapacity(this.buffer.position() + length);
        this.buffer.put(src, offset, length);
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.buffer.capacity()) {
            return;
        }
        int newCapacity = (int)((float)this.buffer.capacity() * (1.0f + this.loadFactor));
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer result = this.buffer.duplicate();
        result.flip();
        return result;
    }

    public byte[] getByteArray() {
        ByteBuffer data = this.getByteBuffer();
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        return bytes;
    }

    public int transferFrom(ReadableByteChannel channel) throws IOException {
        this.ensureCapacity(this.buffer.position() + 1);
        return channel.read(this.buffer);
    }

    public int transferFully(InputStream inputStream) throws IOException {
        return this.transferFully(Channels.newChannel(inputStream));
    }

    public int transferFully(ReadableByteChannel channel) throws IOException {
        int total = 0;
        int read = 0;
        while ((read = this.transferFrom(channel)) >= 0) {
            total += read;
        }
        return total;
    }

    public int position() {
        return this.buffer.position();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public void rewind() {
        this.buffer.rewind();
    }
}

