/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EntryList<K, V>
extends AbstractMap<K, V> {
    private List<? extends K> keys;
    private List<? extends V> values;

    public EntryList(List<? extends K> keys, List<? extends V> values) {
        this.keys = keys != null ? keys : Collections.emptyList();
        this.values = values != null ? values : Collections.emptyList();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private Iterator<? extends K> keySeq;
                    private Iterator<? extends V> valueSeq;
                    {
                        this.keySeq = EntryList.this.keys.iterator();
                        this.valueSeq = EntryList.this.values.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keySeq.hasNext() || this.valueSeq.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object key = this.keySeq.hasNext() ? (Object)this.keySeq.next() : null;
                        Object value = this.valueSeq.hasNext() ? (Object)this.valueSeq.next() : null;
                        return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
                    }
                };
            }

            @Override
            public int size() {
                return EntryList.this.keys.size();
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return EntryList.this.keys.iterator();
            }

            @Override
            public int size() {
                return EntryList.this.keys.size();
            }
        };
    }

    @Override
    public List<V> values() {
        return this.values;
    }

    @Override
    public int size() {
        return Math.max(this.keys.size(), this.values.size());
    }
}

