/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;

public class FastFile
extends File {
    private static final long UNDEFINED = -1L;
    public static final int HIDDEN = 0;
    public static final int DIRECTORY = 1;
    public static final int FILE = 2;
    private BitSet stats;
    private String name;
    private long length = -1L;
    private long lastModified = -1L;
    private long totalSpace = -1L;
    private long freeSpace = -1L;
    private String[] list;
    private File[] listFiles;
    private File canonicalFile;
    private File parentFile;

    public FastFile(File file) {
        super(file.getPath());
    }

    public FastFile(File parentFile, String name) {
        super(parentFile, name);
        this.parentFile = parentFile;
        this.name = name;
    }

    public boolean stats(int bitIndex) {
        if (this.stats == null) {
            this.stats = new BitSet(3);
            this.stats.set(0, super.isHidden());
            if (super.isFile()) {
                this.stats.set(2);
            } else if (super.isDirectory()) {
                this.stats.set(1);
            }
        }
        return this.stats.get(bitIndex);
    }

    @Override
    public boolean isDirectory() {
        return this.stats(1);
    }

    @Override
    public boolean isFile() {
        return this.stats(2);
    }

    @Override
    public boolean isHidden() {
        return this.stats(0);
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : (this.name = super.getName());
    }

    @Override
    public long length() {
        return this.length != -1L ? this.length : (this.length = super.length());
    }

    @Override
    public long lastModified() {
        return this.lastModified != -1L ? this.lastModified : (this.lastModified = super.lastModified());
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this.canonicalFile != null ? this.canonicalFile : (this.canonicalFile = FastFile.get(super.getCanonicalFile()));
    }

    @Override
    public File getParentFile() {
        return this.parentFile != null ? this.parentFile : (this.parentFile = FastFile.get(super.getParentFile()));
    }

    @Override
    public String[] list() {
        if (this.list != null) {
            return this.list;
        }
        String[] names = super.list();
        if (names == null) {
            names = new String[]{};
        }
        this.list = names;
        return names;
    }

    @Override
    public File[] listFiles() {
        if (this.listFiles != null) {
            return this.listFiles;
        }
        this.listFiles = (File[])Arrays.stream(this.list()).map(s -> new FastFile(this, (String)s)).toArray(File[]::new);
        return this.listFiles;
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        return (File[])Arrays.stream(this.listFiles()).filter(filter::accept).toArray(File[]::new);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public long getTotalSpace() {
        return this.totalSpace != -1L ? this.totalSpace : (this.totalSpace = super.getTotalSpace());
    }

    @Override
    public long getUsableSpace() {
        return this.freeSpace != -1L ? this.freeSpace : (this.freeSpace = super.getUsableSpace());
    }

    @Override
    public long getFreeSpace() {
        return this.freeSpace != -1L ? this.freeSpace : (this.freeSpace = super.getUsableSpace());
    }

    @Override
    public boolean createNewFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mkdirs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean renameTo(File dest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setLastModified(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setWritable(boolean writable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setReadable(boolean readable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setExecutable(boolean executable) {
        throw new UnsupportedOperationException();
    }

    public static FastFile get(File f) {
        return f == null ? null : new FastFile(f);
    }
}

