/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.List;

public class ListChangeSynchronizer<E>
implements ListEventListener<E> {
    private final List<E> target;

    public ListChangeSynchronizer(EventList<E> source, List<E> target) {
        this.target = target;
        source.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        EventList<E> source = listChanges.getSourceList();
        while (listChanges.next()) {
            int index = listChanges.getIndex();
            int type = listChanges.getType();
            switch (type) {
                case 2: {
                    this.target.add(index, source.get(index));
                    break;
                }
                case 1: {
                    this.target.set(index, source.get(index));
                    break;
                }
                case 0: {
                    this.target.remove(index);
                }
            }
        }
    }

    public static <E> ListChangeSynchronizer<E> syncEventListToList(EventList<E> source, List<E> target) {
        return new ListChangeSynchronizer<E>(source, target);
    }
}

