/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.filebot.Logging;
import net.filebot.util.DefaultThreadFactory;

public abstract class Timer
implements Runnable {
    private final ThreadFactory threadFactory = new DefaultThreadFactory("Timer", 5, true);
    private ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> scheduledFuture;
    private Thread shutdownHook;

    public synchronized void set(long delay, TimeUnit unit, boolean runBeforeShutdown) {
        if (this.executor == null) {
            this.executor = new ScheduledThreadPoolExecutor(1, this.threadFactory);
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        Runnable runnable = this;
        if (runBeforeShutdown) {
            try {
                this.addShutdownHook();
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
            }
            runnable = () -> {
                try {
                    this.run();
                }
                finally {
                    this.cancel();
                }
            };
        } else {
            try {
                this.removeShutdownHook();
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
            }
        }
        this.scheduledFuture = this.executor.schedule(runnable, delay, unit);
    }

    public synchronized void cancel() {
        this.removeShutdownHook();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.scheduledFuture = null;
        this.executor = null;
    }

    private synchronized void addShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    private synchronized void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                if (this.shutdownHook != Thread.currentThread()) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            finally {
                this.shutdownHook = null;
            }
        }
    }
}

