/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class TreeIterator<T>
implements Iterator<T> {
    private final LinkedList<Iterator<T>> recursionStack = new LinkedList();

    public TreeIterator(T ... root) {
        this.recursionStack.push(Arrays.asList(root).iterator());
    }

    protected abstract Iterator<T> children(T var1);

    @Override
    public boolean hasNext() {
        return this.currentIterator().hasNext();
    }

    @Override
    public T next() {
        T node = this.currentIterator().next();
        Iterator<T> children = this.children(node);
        if (children != null && children.hasNext()) {
            this.recursionStack.push(children);
        }
        return node;
    }

    private Iterator<T> currentIterator() {
        Iterator<T> iterator = this.recursionStack.peek();
        if (iterator.hasNext() || this.recursionStack.size() <= 1) {
            return iterator;
        }
        this.recursionStack.pop();
        return this.currentIterator();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

