/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathUtilities {
    public static Node selectNode(String xpath, Object node) {
        return (Node)XPathUtilities.evaluateXPath(xpath, node, XPathConstants.NODE);
    }

    public static String selectString(String xpath, Object node) {
        return ((String)XPathUtilities.evaluateXPath(xpath, node, XPathConstants.STRING)).trim();
    }

    public static Stream<Node> streamNodes(String xpath, Object node) {
        return XPathUtilities.stream((NodeList)XPathUtilities.evaluateXPath(xpath, node, XPathConstants.NODESET));
    }

    public static Node[] selectNodes(String xpath, Object node) {
        return (Node[])XPathUtilities.streamNodes(xpath, node).toArray(Node[]::new);
    }

    public static List<String> selectStrings(String xpath, Object node) {
        ArrayList<String> values = new ArrayList<String>();
        for (Node it : XPathUtilities.selectNodes(xpath, node)) {
            String textContent = XPathUtilities.getTextContent(it);
            if (textContent.length() <= 0) continue;
            values.add(textContent);
        }
        return values;
    }

    public static Node getChild(String nodeName, Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        return XPathUtilities.stream(parentNode.getChildNodes()).filter(n -> nodeName.equals(n.getNodeName())).findFirst().orElse(null);
    }

    public static Node[] getChildren(String nodeName, Node parentNode) {
        if (parentNode == null) {
            return new Node[0];
        }
        return (Node[])XPathUtilities.stream(parentNode.getChildNodes()).filter(n -> nodeName.equals(n.getNodeName())).toArray(Node[]::new);
    }

    public static String getAttribute(String attribute, Node node) {
        Node attr;
        if (node != null && (attr = node.getAttributes().getNamedItem(attribute)) != null) {
            return attr.getNodeValue().trim();
        }
        return null;
    }

    public static String getTextContent(String childName, Node parentNode) {
        Node child = XPathUtilities.getChild(childName, parentNode);
        if (child == null) {
            return null;
        }
        return XPathUtilities.getTextContent(child);
    }

    public static String getTextContent(Node node) {
        StringBuilder sb = new StringBuilder();
        for (Node textNode : XPathUtilities.getChildren("#text", node)) {
            sb.append(textNode.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static List<String> getListContent(String childName, String delimiter, Node parentNode) {
        ArrayList<String> list = new ArrayList<String>();
        for (Node node : XPathUtilities.getChildren(childName, parentNode)) {
            String textContent = XPathUtilities.getTextContent(node);
            if (textContent == null || textContent.length() <= 0) continue;
            if (delimiter == null) {
                list.add(textContent);
                continue;
            }
            for (String it : textContent.split(delimiter)) {
                if ((it = it.trim()).length() <= 0) continue;
                list.add(it);
            }
        }
        return list;
    }

    public static Double getDecimal(String textContent) {
        try {
            return Double.parseDouble(textContent);
        }
        catch (NullPointerException | NumberFormatException e) {
            return null;
        }
    }

    public static Object evaluateXPath(String xpath, Object item, QName returnType) {
        try {
            return XPathFactory.newInstance().newXPath().compile(xpath).evaluate(item, returnType);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Stream<Node> streamElements(Node parent) {
        return XPathUtilities.stream(parent.getChildNodes()).filter(n -> n.getNodeType() == 1);
    }

    public static Stream<Node> stream(NodeList nodes) {
        return IntStream.range(0, nodes.getLength()).mapToObj(nodes::item);
    }

    public static <K extends Enum<K>> EnumMap<K, String> getEnumMap(Node node, Class<K> cls) {
        EnumMap<Enum, String> map = new EnumMap<Enum, String>(cls);
        for (Enum key : (Enum[])cls.getEnumConstants()) {
            String value = XPathUtilities.getTextContent(key.name(), node);
            if (value == null || value.length() <= 0) continue;
            map.put(key, value);
        }
        return map;
    }

    private XPathUtilities() {
        throw new UnsupportedOperationException();
    }
}

