/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.filebot.CachedResource;
import net.filebot.Logging;
import net.filebot.web.Crew;
import net.filebot.web.Person;
import net.filebot.web.SimpleDate;
import net.filebot.web.Trailer;

public class MovieInfo
implements Crew,
Serializable {
    protected Map<Property, String> fields;
    protected String[] alternativeTitles;
    protected String[] genres;
    protected String[] spokenLanguages;
    protected String[] productionCountries;
    protected String[] productionCompanies;
    protected Map<String, String> certifications;
    protected Person[] people;
    protected Trailer[] trailers;

    public MovieInfo() {
    }

    public MovieInfo(Map<Property, String> fields, List<String> alternativeTitles, List<String> genres, Map<String, String> certifications, List<String> spokenLanguages, List<String> productionCountries, List<String> productionCompanies, List<Person> people, List<Trailer> trailers) {
        this.fields = new EnumMap<Property, String>(fields);
        this.alternativeTitles = alternativeTitles.toArray(new String[0]);
        this.genres = genres.toArray(new String[0]);
        this.certifications = new LinkedHashMap<String, String>(certifications);
        this.spokenLanguages = spokenLanguages.toArray(new String[0]);
        this.productionCountries = productionCountries.toArray(new String[0]);
        this.productionCompanies = productionCompanies.toArray(new String[0]);
        this.people = people.toArray(new Person[0]);
        this.trailers = trailers.toArray(new Trailer[0]);
    }

    public String get(Object key) {
        return this.fields.get((Object)Property.valueOf(key.toString()));
    }

    public String get(Property key) {
        return this.fields.get((Object)key);
    }

    private <T> T get(Property key, CachedResource.Transform<String, T> cast) {
        try {
            String value = this.fields.get((Object)key);
            if (value != null && !value.isEmpty()) {
                return cast.transform(value);
            }
        }
        catch (Exception e) {
            Logging.debug.log(Level.WARNING, Logging.format("Failed to parse %s value: %s: %s", new Object[]{key, e, this.fields}));
        }
        return null;
    }

    public String getName() {
        return this.get(Property.title);
    }

    public String getOriginalName() {
        return this.get(Property.original_title);
    }

    public String getOriginalLanguage() {
        return this.get(Property.original_language);
    }

    public String getCollection() {
        return this.get(Property.collection);
    }

    public String getCertification() {
        return this.get(Property.certification);
    }

    public boolean isAdult() {
        return this.get(Property.adult, Boolean::parseBoolean);
    }

    public String getTagline() {
        return this.get(Property.tagline);
    }

    public String getOverview() {
        return this.get(Property.overview);
    }

    public Integer getId() {
        return this.get(Property.id, Integer::parseInt);
    }

    public Integer getImdbId() {
        return this.get(Property.imdb_id, s -> Integer.parseInt(s.substring(2)));
    }

    public Integer getVotes() {
        return this.get(Property.vote_count, Integer::parseInt);
    }

    public Double getRating() {
        return this.get(Property.vote_average, Double::parseDouble);
    }

    public SimpleDate getReleased() {
        return this.get(Property.release_date, SimpleDate::parse);
    }

    public Integer getRuntime() {
        return this.get(Property.runtime, Integer::parseInt);
    }

    public Long getBudget() {
        return this.get(Property.budget, Long::parseLong);
    }

    public Long getRevenue() {
        return this.get(Property.revenue, Long::parseLong);
    }

    public Double getPopularity() {
        return this.get(Property.popularity, Double::parseDouble);
    }

    public URL getHomepage() {
        return this.get(Property.homepage, URL::new);
    }

    public URL getPoster() {
        return this.get(Property.poster_path, URL::new);
    }

    public List<String> getGenres() {
        return Collections.unmodifiableList(Arrays.asList(this.genres));
    }

    public List<Locale> getSpokenLanguages() {
        return Arrays.stream(this.spokenLanguages).map(Locale::new).collect(Collectors.toList());
    }

    @Override
    public List<Person> getCrew() {
        return Collections.unmodifiableList(Arrays.asList(this.people));
    }

    public Map<String, String> getCertifications() {
        return Collections.unmodifiableMap(this.certifications);
    }

    public List<String> getProductionCountries() {
        return Collections.unmodifiableList(Arrays.asList(this.productionCountries));
    }

    public List<String> getProductionCompanies() {
        return Collections.unmodifiableList(Arrays.asList(this.productionCompanies));
    }

    public List<Trailer> getTrailers() {
        return Collections.unmodifiableList(Arrays.asList(this.trailers));
    }

    public List<String> getAlternativeTitles() {
        return Collections.unmodifiableList(Arrays.asList(this.alternativeTitles));
    }

    public String toString() {
        return this.fields.toString();
    }

    public static enum Property {
        adult,
        backdrop_path,
        budget,
        homepage,
        id,
        imdb_id,
        original_title,
        original_language,
        overview,
        popularity,
        poster_path,
        release_date,
        revenue,
        runtime,
        tagline,
        title,
        vote_average,
        vote_count,
        certification,
        collection;

    }
}

