/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.media.MediaDetection;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.util.ExceptionUtilities;
import net.filebot.util.FileUtilities;
import net.filebot.util.JsonUtilities;
import net.filebot.util.Timer;
import net.filebot.web.Movie;
import net.filebot.web.MovieIdentificationService;
import net.filebot.web.OpenSubtitlesHasher;
import net.filebot.web.OpenSubtitlesXmlRpc;
import net.filebot.web.SubtitleDescriptor;
import net.filebot.web.SubtitleProvider;
import net.filebot.web.SubtitleSearchResult;
import net.filebot.web.VideoHashSubtitleService;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcFault;

public class OpenSubtitlesClient
implements SubtitleProvider,
VideoHashSubtitleService,
MovieIdentificationService {
    public final OpenSubtitlesXmlRpc xmlrpc;
    private String username = "";
    private String password = "";
    protected final Timer logoutTimer = new Timer(){

        @Override
        public void run() {
            OpenSubtitlesClient.this.logout();
        }
    };

    public OpenSubtitlesClient(String name, String version) {
        this.xmlrpc = new OpenSubtitlesXmlRpcWithRetryAndFloodLimit(String.format("%s v%s", name, version), 2, 3000L);
    }

    @Override
    public String getIdentifier() {
        return "OpenSubtitles";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.opensubtitles");
    }

    @Override
    public URI getLink() {
        return URI.create("http://www.opensubtitles.org");
    }

    public synchronized void setUser(String username, String password_md5) {
        this.logout();
        this.username = username;
        this.password = password_md5;
    }

    public boolean isAnonymous() {
        return this.username == null || this.username.isEmpty();
    }

    @Override
    public List<SubtitleSearchResult> search(String query) throws Exception {
        throw new UnsupportedOperationException("XMLRPC::SearchMoviesOnIMDB has been banned due to abuse");
    }

    @Override
    public List<Movie> searchMovie(String query, Locale locale) throws Exception {
        throw new UnsupportedOperationException("XMLRPC::SearchMoviesOnIMDB has been banned due to abuse");
    }

    @Override
    public synchronized List<SubtitleSearchResult> guess(String tag) throws Exception {
        return this.getSearchCache("tag").computeIfAbsent(tag, it -> {
            this.login();
            return this.xmlrpc.guessMovie(Collections.singleton(tag)).getOrDefault(tag, Collections.emptyList());
        });
    }

    public synchronized List<SubtitleSearchResult> searchIMDB(String query) throws Exception {
        return this.getSearchCache("query").computeIfAbsent(query, it -> {
            this.login();
            return this.xmlrpc.searchMoviesOnIMDB(query);
        });
    }

    public synchronized List<SubtitleDescriptor> getSubtitleList(OpenSubtitlesXmlRpc.Query query) throws Exception {
        return this.getSubtitlesCache().computeIfAbsent(query, it -> {
            this.login();
            return this.xmlrpc.searchSubtitles(Collections.singleton(query));
        });
    }

    public List<SubtitleDescriptor> getSubtitleList(SubtitleSearchResult searchResult, Locale locale) throws Exception {
        return this.getSubtitleList(searchResult, -1, -1, locale);
    }

    @Override
    public List<SubtitleDescriptor> getSubtitleList(SubtitleSearchResult searchResult, int[][] episodeFilter, Locale locale) throws Exception {
        if (episodeFilter == null || episodeFilter.length == 0) {
            return this.getSubtitleList(searchResult, -1, -1, locale);
        }
        int[] seasons = Arrays.stream(episodeFilter).mapToInt(ii -> ii[0]).filter(i -> i >= 0).sorted().distinct().toArray();
        int[] episodes = Arrays.stream(episodeFilter).mapToInt(ii -> ii[1]).filter(i -> i >= 0).sorted().distinct().toArray();
        if (seasons.length == 0 && episodes.length == 0) {
            return this.getSubtitleList(searchResult, -1, -1, locale);
        }
        if (seasons.length == 1 && episodes.length == 1) {
            return this.getSubtitleList(searchResult, seasons[0], episodes[0], locale);
        }
        if (seasons.length > 0 && episodes.length == 0) {
            return Arrays.stream(seasons).boxed().flatMap(s -> {
                try {
                    return this.getSubtitleList(searchResult, (int)s, -1, locale).stream();
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Failed to retrieve subtitle list for season: %s S%02d [%s]", searchResult, s, locale), e);
                }
            }).distinct().collect(Collectors.toList());
        }
        return Arrays.stream(episodeFilter).flatMap(ii -> {
            try {
                return this.getSubtitleList(searchResult, ii[0], ii[1], locale).stream();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to retrieve subtitle list for episode: %s %s [%s]", searchResult, Arrays.asList(ii), locale), e);
            }
        }).distinct().collect(Collectors.toList());
    }

    public synchronized List<SubtitleDescriptor> getSubtitleList(SubtitleSearchResult searchResult, int season, int episode, Locale locale) throws Exception {
        OpenSubtitlesXmlRpc.Query query = OpenSubtitlesXmlRpc.Query.forImdbId(searchResult.getImdbId(), season, episode, this.getLanguageFilter(locale));
        return this.getSubtitlesCache().computeIfAbsent(query, it -> {
            this.login();
            return this.xmlrpc.searchSubtitles(Collections.singleton(query));
        });
    }

    @Override
    public Map<File, List<SubtitleDescriptor>> getSubtitleList(File[] files, Locale locale) throws Exception {
        HashMap<File, List<SubtitleDescriptor>> results = new HashMap<File, List<SubtitleDescriptor>>(files.length);
        HashSet<File> remainingFiles = new HashSet<File>(Arrays.asList(files));
        if (remainingFiles.size() > 0) {
            results.putAll(this.getSubtitleListByHash(remainingFiles.toArray(new File[0]), locale));
        }
        results.forEach((k, v) -> {
            if (v.size() > 0) {
                remainingFiles.remove(k);
            }
        });
        return results;
    }

    protected Map<File, List<SubtitleDescriptor>> getSubtitleList(File[] files, Function<File, OpenSubtitlesXmlRpc.Query> queryMapper) throws Exception {
        HashMap<File, List<SubtitleDescriptor>> results = new HashMap<File, List<SubtitleDescriptor>>(files.length);
        for (File f : files) {
            OpenSubtitlesXmlRpc.Query query = queryMapper.apply(f);
            if (query != null) {
                results.put(f, this.getSubtitleList(query));
                continue;
            }
            results.put(f, Collections.emptyList());
        }
        return results;
    }

    public Map<File, List<SubtitleDescriptor>> getSubtitleListByHash(File[] files, Locale locale) throws Exception {
        return this.getSubtitleList(files, (File f) -> {
            if (f.length() > 65536L) {
                try {
                    String hash = OpenSubtitlesHasher.computeHash(f);
                    return OpenSubtitlesXmlRpc.Query.forHash(hash, f.length(), this.getLanguageFilter(locale));
                }
                catch (Exception e) {
                    Logging.debug.log(Level.SEVERE, "Failed to compute hash", e);
                }
            } else {
                try {
                    Map<?, ?> json = JsonUtilities.asMap(JsonUtilities.readJson(FileUtilities.readTextFile(f)));
                    if (json != null) {
                        return OpenSubtitlesXmlRpc.Query.forHash(json.get("hash").toString(), Long.parseLong(json.get("size").toString()), this.getLanguageFilter(locale));
                    }
                }
                catch (Exception e) {
                    Logging.debug.finest("Ignore sample file: " + f);
                }
            }
            return null;
        });
    }

    public Map<File, List<SubtitleDescriptor>> getSubtitleListByTag(File[] files, Locale locale) throws Exception {
        return this.getSubtitleList(files, (File f) -> {
            String tag = FileUtilities.getNameWithoutExtension(f.getName());
            return OpenSubtitlesXmlRpc.Query.forTag(tag, this.getLanguageFilter(locale));
        });
    }

    @Override
    public synchronized VideoHashSubtitleService.CheckResult checkSubtitle(File videoFile, File subtitleFile) throws Exception {
        this.login();
        OpenSubtitlesXmlRpc.SubFile subFile = this.getSubFile(videoFile, subtitleFile, false);
        OpenSubtitlesXmlRpc.TryUploadResponse response = this.xmlrpc.tryUploadSubtitles(subFile);
        boolean exists = !response.isUploadRequired();
        Movie identity = null;
        Locale language = null;
        if (response.getSubtitleData().size() > 0) {
            try {
                Map<String, String> fields = response.getSubtitleData().get(0);
                String lang = fields.get("SubLanguageID");
                language = new Locale(lang);
                String imdb = fields.get("IDMovieImdb");
                String name = fields.get("MovieName");
                String year = fields.get("MovieYear");
                identity = new Movie(name, Integer.parseInt(year), Integer.parseInt(imdb));
            }
            catch (Exception e) {
                Logging.debug.log(Level.SEVERE, "Failed to upload subtitles", e);
            }
        }
        return new VideoHashSubtitleService.CheckResult(exists, identity, language);
    }

    @Override
    public synchronized void uploadSubtitle(Object identity, Locale locale, File[] videoFile, File[] subtitleFile) throws Exception {
        int imdbid = -1;
        try {
            imdbid = ((Movie)identity).getImdbId();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal Movie ID: " + identity);
        }
        String subLanguageID = this.getSubLanguageID(locale);
        OpenSubtitlesXmlRpc.BaseInfo info = new OpenSubtitlesXmlRpc.BaseInfo();
        info.setIDMovieImdb(imdbid);
        info.setSubLanguageID(subLanguageID);
        OpenSubtitlesXmlRpc.SubFile[] subFiles = new OpenSubtitlesXmlRpc.SubFile[videoFile.length];
        for (int i = 0; i < subFiles.length; ++i) {
            subFiles[i] = this.getSubFile(videoFile[i], subtitleFile[i], true);
        }
        this.login();
        this.xmlrpc.uploadSubtitles(info, subFiles);
    }

    protected OpenSubtitlesXmlRpc.SubFile getSubFile(File videoFile, File subtitleFile, boolean content) throws IOException {
        OpenSubtitlesXmlRpc.SubFile sub = new OpenSubtitlesXmlRpc.SubFile();
        sub.setSubHash(FileUtilities.md5(FileUtilities.readFile(subtitleFile)));
        sub.setSubFileName(subtitleFile.getName());
        sub.setMovieHash(OpenSubtitlesHasher.computeHash(videoFile));
        sub.setMovieByteSize(videoFile.length());
        sub.setMovieFileName(videoFile.getName());
        if (content) {
            sub.setSubContent(FileUtilities.readFile(subtitleFile));
        }
        try (MediaInfo mi = new MediaInfo().open(videoFile);){
            sub.setMovieFPS(mi.get(MediaInfo.StreamKind.Video, 0, "FrameRate"));
            sub.setMovieTimeMS(mi.get(MediaInfo.StreamKind.General, 0, "Duration"));
        }
        catch (Throwable e) {
            Logging.debug.log(Level.SEVERE, "Failed to read media info", e);
        }
        return sub;
    }

    @Override
    public synchronized Movie getMovieDescriptor(Movie id, Locale locale) throws Exception {
        if (id.getImdbId() <= 0) {
            throw new IllegalArgumentException("Illegal IMDbID ID: " + id.getImdbId());
        }
        return this.getLookupCache(locale).computeIfAbsent(id.getImdbId(), it -> {
            this.login();
            return this.xmlrpc.getIMDBMovieDetails(id.getImdbId());
        });
    }

    public Movie getMovieDescriptor(File movieFile, Locale locale) throws Exception {
        return this.getMovieDescriptors(Collections.singleton(movieFile), locale).get(movieFile);
    }

    public synchronized Map<File, Movie> getMovieDescriptors(Collection<File> movieFiles, Locale locale) throws Exception {
        HashMap<File, Movie> results = new HashMap<File, Movie>();
        int minSeenCount = 20;
        for (File f : movieFiles) {
            if (f.length() <= 65536L) continue;
            String hash = OpenSubtitlesHasher.computeHash(f);
            Movie match = this.getLookupCache(locale).computeIfAbsent(hash, it -> this.xmlrpc.checkMovieHash(Collections.singleton(hash), minSeenCount).get(hash));
            results.put(f, match);
        }
        return results;
    }

    @Override
    public URI getSubtitleListLink(SubtitleSearchResult searchResult, Locale locale) {
        return URI.create(String.format("http://www.opensubtitles.org/en/search/imdbid-%d/sublanguageid-%s", searchResult.getImdbId(), this.getSubLanguageID(locale)));
    }

    public synchronized Locale detectLanguage(byte[] data) throws Exception {
        if (data.length < 256) {
            throw new IllegalArgumentException("Data is too small: " + data.length);
        }
        List<String> languages = this.getCache("detect").castList(String.class).computeIfAbsent(FileUtilities.md5(data), it -> {
            this.login();
            return this.xmlrpc.detectLanguage(data);
        });
        return languages.size() > 0 ? new Locale(languages.get(0)) : Locale.ROOT;
    }

    public synchronized void login() throws Exception {
        if (!this.xmlrpc.isLoggedOn()) {
            this.xmlrpc.login(this.username, this.password, "en");
        }
        this.logoutTimer.set(10L, TimeUnit.MINUTES, true);
    }

    public synchronized void logout() {
        if (this.xmlrpc.isLoggedOn()) {
            try {
                this.xmlrpc.logout();
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, "Failed to log out", e);
            }
        }
        this.logoutTimer.cancel();
    }

    public synchronized Map<?, ?> getServerInfo() throws Exception {
        this.login();
        return this.xmlrpc.getServerInfo();
    }

    public Map<?, ?> getDownloadLimits() throws Exception {
        return (Map)this.getServerInfo().get("download_limits");
    }

    protected synchronized Map<String, String> getSubLanguageMap() throws Exception {
        HashMap<String, String> subLanguageMap = new HashMap<String, String>();
        Cache cache = Cache.getCache(this.getName() + "_languages", CacheType.Persistent);
        Map m = (Map)cache.computeIfAbsent("subLanguageMap", k -> this.xmlrpc.getSubLanguages());
        Map<String, Locale> additionalLanguageMappings = MediaDetection.releaseInfo.getLanguageMap(Locale.ENGLISH);
        m.forEach((k, v) -> {
            String subLanguageID = k.toString().toLowerCase();
            String languageCode = v.toString().toLowerCase();
            subLanguageMap.put(languageCode, subLanguageID);
            subLanguageMap.put(subLanguageID, subLanguageID);
            for (String key : new String[]{subLanguageID, languageCode}) {
                Locale locale = (Locale)additionalLanguageMappings.get(key);
                if (locale == null) continue;
                for (String identifier : Arrays.asList(locale.getLanguage(), locale.getISO3Language(), locale.getDisplayLanguage(Locale.ENGLISH))) {
                    if (identifier == null || identifier.length() <= 0 || subLanguageMap.containsKey(identifier.toLowerCase())) continue;
                    subLanguageMap.put(identifier.toLowerCase(), subLanguageID);
                }
            }
        });
        return subLanguageMap;
    }

    protected String getSubLanguageID(Locale locale) {
        Map<String, String> languageMap;
        if (locale == null || locale.equals(Locale.ROOT)) {
            return "all";
        }
        switch (locale.toString()) {
            case "en_US": {
                return "eng";
            }
            case "pt_BR": {
                return "pob";
            }
            case "zh_CN": {
                return "chi";
            }
            case "zh_TW": {
                return "zht";
            }
            case "iw_IL": {
                return "heb";
            }
        }
        try {
            languageMap = this.getSubLanguageMap();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to retrieve subtitle language map", e);
        }
        String subLanguageID = languageMap.get(locale.getLanguage());
        if (subLanguageID == null) {
            throw new IllegalArgumentException("SubLanguageID not found: " + locale);
        }
        return subLanguageID;
    }

    protected String[] getLanguageFilter(Locale locale) {
        String[] stringArray;
        if (locale == null || locale.getLanguage().isEmpty()) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getSubLanguageID(locale);
        }
        return stringArray;
    }

    public Cache getCache(String section) {
        return Cache.getCache(this.getName() + "_" + section, CacheType.Daily);
    }

    protected Cache.TypedCache<List<SubtitleSearchResult>> getSearchCache(String method) {
        return this.getCache("search_" + method).castList(SubtitleSearchResult.class);
    }

    protected Cache.TypedCache<List<SubtitleDescriptor>> getSubtitlesCache() {
        return this.getCache("data").castList(SubtitleDescriptor.class);
    }

    protected Cache.TypedCache<Movie> getLookupCache(Locale locale) {
        return this.getCache("lookup_" + locale).cast(Movie.class);
    }

    protected static class OpenSubtitlesXmlRpcWithRetryAndFloodLimit
    extends OpenSubtitlesXmlRpc {
        private final Object lock = new Object();
        private int retryCountLimit;
        private long retryWaitTime;

        public OpenSubtitlesXmlRpcWithRetryAndFloodLimit(String useragent, int retryCountLimit, long retryWaitTime) {
            super(useragent);
            this.retryCountLimit = retryCountLimit;
            this.retryWaitTime = retryWaitTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Map<?, ?> invoke(String method, Object ... arguments) throws XmlRpcFault {
            for (int i = 0; this.retryCountLimit < 0 || i <= this.retryCountLimit; ++i) {
                try {
                    if (i > 0) {
                        Thread.sleep(this.retryWaitTime);
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        return super.invoke(method, arguments);
                    }
                }
                catch (XmlRpcException e) {
                    IOException ioException = ExceptionUtilities.findCause(e, IOException.class);
                    if (ioException != null && (i < 0 || i < this.retryCountLimit)) continue;
                    throw e;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }
}

