/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public final class OpenSubtitlesHasher {
    public static final int HASH_CHUNK_SIZE = 65536;

    public static String computeHashNIO(File file) throws IOException {
        long size = file.length();
        long chunkSizeForFile = Math.min(65536L, size);
        try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            long head = OpenSubtitlesHasher.computeHashForChunk(channel.map(FileChannel.MapMode.READ_ONLY, 0L, chunkSizeForFile));
            long tail = OpenSubtitlesHasher.computeHashForChunk(channel.map(FileChannel.MapMode.READ_ONLY, Math.max(size - 65536L, 0L), chunkSizeForFile));
            String string = String.format("%016x", size + head + tail);
            return string;
        }
    }

    public static String computeHash(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = OpenSubtitlesHasher.computeHash(in, file.length());
            return string;
        }
    }

    public static String computeHash(InputStream stream, long length) throws IOException {
        int chunkSizeForFile = (int)Math.min(65536L, length);
        byte[] chunkBytes = new byte[(int)Math.min(131072L, length)];
        DataInputStream in = new DataInputStream(stream);
        in.readFully(chunkBytes, 0, chunkSizeForFile);
        long position = chunkSizeForFile;
        long tailChunkPosition = length - (long)chunkSizeForFile;
        while (position < tailChunkPosition && (position += in.skip(tailChunkPosition - position)) >= 0L) {
        }
        in.readFully(chunkBytes, chunkSizeForFile, chunkBytes.length - chunkSizeForFile);
        long head = OpenSubtitlesHasher.computeHashForChunk(ByteBuffer.wrap(chunkBytes, 0, chunkSizeForFile));
        long tail = OpenSubtitlesHasher.computeHashForChunk(ByteBuffer.wrap(chunkBytes, chunkBytes.length - chunkSizeForFile, chunkSizeForFile));
        return String.format("%016x", length + head + tail);
    }

    private static long computeHashForChunk(ByteBuffer buffer) {
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }
}

