/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SearchResult
implements Serializable {
    protected int id;
    protected String name;
    protected String[] aliasNames;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public SearchResult() {
    }

    public SearchResult(int id) {
        this(id, null, EMPTY_STRING_ARRAY);
    }

    public SearchResult(int id, String name) {
        this(id, name, EMPTY_STRING_ARRAY);
    }

    public SearchResult(int id, String name, Collection<String> aliasNames) {
        this(id, name, aliasNames.toArray(EMPTY_STRING_ARRAY));
    }

    public SearchResult(int id, String name, String[] aliasNames) {
        this.id = id;
        this.name = name;
        this.aliasNames = aliasNames == null || aliasNames.length == 0 ? EMPTY_STRING_ARRAY : (String[])aliasNames.clone();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliasNames() {
        return (String[])this.aliasNames.clone();
    }

    public List<String> getEffectiveNames() {
        if (this.name == null || this.name.length() == 0) {
            return Collections.emptyList();
        }
        if (this.aliasNames == null || this.aliasNames.length == 0) {
            return Collections.singletonList(this.name);
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return index == 0 ? SearchResult.this.name : SearchResult.this.aliasNames[index - 1];
            }

            @Override
            public int size() {
                return 1 + SearchResult.this.aliasNames.length;
            }
        };
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this.getClass().isInstance(other)) {
            return this.getId() == ((SearchResult)other).getId();
        }
        return false;
    }

    public String toString() {
        return this.name != null ? this.name : String.valueOf(this.id);
    }

    public SearchResult clone() {
        return new SearchResult(this.id, this.name, this.aliasNames);
    }
}

