/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.filebot.web.Datasource;
import net.filebot.web.SimpleDate;
import net.filebot.web.SortOrder;

public class SeriesInfo
implements Serializable {
    protected String database;
    protected String order;
    protected String language;
    protected Integer id;
    protected String name;
    protected String[] aliasNames;
    protected String certification;
    protected SimpleDate startDate;
    protected String[] genres;
    protected String network;
    protected Double rating;
    protected Integer ratingCount;
    protected Integer runtime;
    protected String status;

    public SeriesInfo() {
    }

    public SeriesInfo(SeriesInfo other) {
        this.database = other.database;
        this.order = other.order;
        this.language = other.language;
        this.id = other.id;
        this.name = other.name;
        this.aliasNames = other.aliasNames == null ? null : (String[])other.aliasNames.clone();
        this.certification = other.certification;
        this.startDate = other.startDate == null ? null : other.startDate.clone();
        this.genres = other.genres == null ? null : (String[])other.genres.clone();
        this.network = other.network;
        this.rating = other.rating;
        this.ratingCount = other.ratingCount;
        this.runtime = other.runtime;
        this.status = other.status;
    }

    public SeriesInfo(Datasource database, Locale language, Integer id) {
        this.database = database.getIdentifier();
        this.language = language.getLanguage();
        this.id = id;
    }

    public SeriesInfo(Datasource database, SortOrder order, Locale language, Integer id) {
        this.database = database.getIdentifier();
        this.order = order.name();
        this.language = language.getLanguage();
        this.id = id;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getOrder() {
        return this.order;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAliasNames() {
        return this.aliasNames == null ? Collections.emptyList() : Arrays.asList((String[])this.aliasNames.clone());
    }

    public void setAliasNames(String ... aliasNames) {
        this.aliasNames = (String[])aliasNames.clone();
    }

    public String getCertification() {
        return this.certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }

    public SimpleDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(SimpleDate startDate) {
        this.startDate = startDate;
    }

    public List<String> getGenres() {
        return this.genres == null ? Collections.emptyList() : Arrays.asList((String[])this.genres.clone());
    }

    public void setGenres(List<String> genres) {
        this.genres = genres.toArray(new String[genres.size()]);
    }

    public String getNetwork() {
        return this.network;
    }

    public void setNetwork(String network) {
        this.network = network;
    }

    public Double getRating() {
        return this.rating;
    }

    public void setRating(Double rating) {
        this.rating = rating;
    }

    public Integer getRatingCount() {
        return this.ratingCount;
    }

    public void setRatingCount(Integer ratingCount) {
        this.ratingCount = ratingCount;
    }

    public Integer getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Integer runtime) {
        this.runtime = runtime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id;
    }

    public boolean equals(Object object) {
        if (object instanceof SeriesInfo) {
            SeriesInfo other = (SeriesInfo)object;
            return Objects.equals(this.id, other.id) && Objects.equals(this.database, other.database);
        }
        return false;
    }

    public SeriesInfo clone() {
        return new SeriesInfo(this);
    }

    public String toString() {
        return this.database + "::" + this.id;
    }
}

