/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.filebot.util.JsonUtilities;
import net.filebot.web.AbstractEpisodeListProvider;
import net.filebot.web.Episode;
import net.filebot.web.SearchResult;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;
import net.filebot.web.SortOrder;
import net.filebot.web.TMDbClient;

public class TMDbTVClient
extends AbstractEpisodeListProvider {
    private final TMDbClient tmdb;

    public TMDbTVClient(TMDbClient tmdb) {
        this.tmdb = tmdb;
    }

    @Override
    public String getIdentifier() {
        return "TheMovieDB::TV";
    }

    @Override
    public String getName() {
        return this.tmdb.getName();
    }

    @Override
    public Icon getIcon() {
        return this.tmdb.getIcon();
    }

    @Override
    public boolean hasSeasonSupport() {
        return true;
    }

    @Override
    protected SortOrder vetoRequestParameter(SortOrder order) {
        return SortOrder.Airdate;
    }

    @Override
    public URI getEpisodeListLink(SearchResult searchResult) {
        return URI.create("https://www.themoviedb.org/tv/" + searchResult.getId());
    }

    @Override
    protected List<SearchResult> fetchSearchResult(String query, Locale locale) throws Exception {
        Matcher nameYear = this.tmdb.getNameYearMatcher(query);
        if (nameYear.matches()) {
            return this.searchTV(nameYear.group(1).trim(), Integer.parseInt(nameYear.group(2)), locale, true);
        }
        return this.searchTV(query.trim(), -1, locale, true);
    }

    public List<SearchResult> searchTV(String seriesName, int startYear, Locale locale, boolean extendedInfo) throws Exception {
        LinkedHashMap<String, Object> query = new LinkedHashMap<String, Object>(2);
        query.put("query", seriesName);
        if (startYear > 0) {
            query.put("first_air_date_year", startYear);
        }
        Object response = this.tmdb.request("search/tv", query, locale);
        return JsonUtilities.streamJsonObjects(response, "results").map(it -> {
            Integer id = JsonUtilities.getInteger(it, "id");
            String name = JsonUtilities.getString(it, "name");
            String originalName = JsonUtilities.getString(it, "original_name");
            if (name == null) {
                name = originalName;
            }
            if (id == null || name == null) {
                return null;
            }
            String[] alternativeTitles = this.tmdb.getAlternativeTitles("tv/" + id, "results", name, originalName, extendedInfo);
            return new SearchResult((int)id, name, alternativeTitles);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    protected AbstractEpisodeListProvider.SeriesData fetchSeriesData(SearchResult series, SortOrder sortOrder, Locale locale) throws Exception {
        Object tv = this.tmdb.request("tv/" + series.getId(), Collections.emptyMap(), locale);
        String name = JsonUtilities.getString(tv, "name");
        String originalName = JsonUtilities.getString(tv, "original_name");
        SeriesInfo info = new SeriesInfo(this, sortOrder, locale, series.getId());
        info.setName(name);
        info.setAliasNames((String[])Stream.concat(Stream.of(series.getName(), originalName), Stream.of(series.getAliasNames())).filter(Objects::nonNull).filter(s -> !s.equals(name)).distinct().toArray(String[]::new));
        info.setStatus(JsonUtilities.getString(tv, "status"));
        info.setLanguage(JsonUtilities.getString(tv, "original_language"));
        info.setStartDate(JsonUtilities.getStringValue(tv, "first_air_date", SimpleDate::parse));
        info.setRating(JsonUtilities.getStringValue(tv, "vote_average", Double::parseDouble));
        info.setRatingCount(JsonUtilities.getStringValue(tv, "vote_count", Integer::parseInt));
        info.setRuntime(Arrays.stream(JsonUtilities.getArray(tv, "episode_run_time")).map(Object::toString).map(Integer::parseInt).findFirst().orElse(null));
        info.setGenres(JsonUtilities.streamJsonObjects(tv, "genres").map(it -> JsonUtilities.getString(it, "name")).collect(Collectors.toList()));
        info.setNetwork(JsonUtilities.streamJsonObjects(tv, "networks").map(it -> JsonUtilities.getString(it, "name")).findFirst().orElse(null));
        int[] seasons = JsonUtilities.streamJsonObjects(tv, "seasons").mapToInt(it -> JsonUtilities.getInteger(it, "season_number")).toArray();
        ArrayList<Episode> episodes = new ArrayList<Episode>();
        ArrayList specials = new ArrayList();
        for (int s2 : seasons) {
            Object season = this.tmdb.request("tv/" + series.getId() + "/season/" + s2, Collections.emptyMap(), locale);
            JsonUtilities.streamJsonObjects(season, "episodes").forEach(episode -> {
                Integer id = JsonUtilities.getInteger(episode, "id");
                Integer episodeNumber = JsonUtilities.getInteger(episode, "episode_number");
                Integer seasonNumber = JsonUtilities.getInteger(episode, "season_number");
                String episodeTitle = JsonUtilities.getString(episode, "name");
                SimpleDate airdate = JsonUtilities.getStringValue(episode, "air_date", SimpleDate::parse);
                Integer absoluteNumber = episodes.size() + 1;
                if (s2 > 0) {
                    episodes.add(new Episode(name, seasonNumber, episodeNumber, episodeTitle, absoluteNumber, null, airdate, id, info));
                } else {
                    specials.add(new Episode(name, null, null, episodeTitle, null, episodeNumber, airdate, id, info));
                }
            });
        }
        episodes.addAll(specials);
        return new AbstractEpisodeListProvider.SeriesData(info, episodes);
    }
}

