/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.ResourceManager;
import net.filebot.util.JsonUtilities;
import net.filebot.web.AbstractEpisodeListProvider;
import net.filebot.web.Episode;
import net.filebot.web.SearchResult;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;
import net.filebot.web.SortOrder;
import net.filebot.web.WebRequest;

public class TVMazeClient
extends AbstractEpisodeListProvider {
    @Override
    public String getIdentifier() {
        return "TVmaze";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.tvmaze");
    }

    @Override
    public boolean hasSeasonSupport() {
        return true;
    }

    @Override
    protected SortOrder vetoRequestParameter(SortOrder order) {
        return SortOrder.Airdate;
    }

    @Override
    protected Locale vetoRequestParameter(Locale language) {
        return Locale.ENGLISH;
    }

    @Override
    public List<SearchResult> fetchSearchResult(String query, Locale locale) throws Exception {
        Object response = this.request("search/shows?q=" + WebRequest.encode(query, true));
        return JsonUtilities.streamJsonObjects(response).map(it -> {
            Object show = it.get("show");
            Integer id = JsonUtilities.getInteger(show, "id");
            String name = JsonUtilities.getString(show, "name");
            return new SearchResult(id, name);
        }).collect(Collectors.toList());
    }

    protected SeriesInfo fetchSeriesInfo(SearchResult show, SortOrder sortOrder, Locale locale) throws Exception {
        Object response = this.request("shows/" + show.getId());
        String status = JsonUtilities.getStringValue(response, "status", String::new);
        SimpleDate premiered = JsonUtilities.getStringValue(response, "premiered", SimpleDate::parse);
        Integer runtime = JsonUtilities.getStringValue(response, "runtime", Integer::parseInt);
        Object[] genres = JsonUtilities.getArray(response, "genres");
        Double rating = JsonUtilities.getStringValue(JsonUtilities.getMap(response, "rating"), "average", Double::parseDouble);
        SeriesInfo seriesInfo = new SeriesInfo(this, sortOrder, locale, show.getId());
        seriesInfo.setName(show.getName());
        seriesInfo.setAliasNames(show.getAliasNames());
        seriesInfo.setStatus(status);
        seriesInfo.setRuntime(runtime);
        seriesInfo.setStartDate(premiered);
        seriesInfo.setRating(rating);
        seriesInfo.setGenres(Arrays.stream(genres).map(Objects::toString).collect(Collectors.toList()));
        return seriesInfo;
    }

    @Override
    protected AbstractEpisodeListProvider.SeriesData fetchSeriesData(SearchResult searchResult, SortOrder sortOrder, Locale locale) throws Exception {
        SeriesInfo seriesInfo = this.fetchSeriesInfo(searchResult, sortOrder, locale);
        Object response = this.request("shows/" + seriesInfo.getId() + "/episodes");
        List<Episode> episodes = JsonUtilities.streamJsonObjects(response).map(episode -> {
            Integer id = JsonUtilities.getInteger(episode, "id");
            Integer seasonNumber = JsonUtilities.getInteger(episode, "season");
            Integer episodeNumber = JsonUtilities.getInteger(episode, "number");
            String episodeTitle = JsonUtilities.getString(episode, "name");
            SimpleDate airdate = JsonUtilities.getStringValue(episode, "airdate", SimpleDate::parse);
            return new Episode(seriesInfo.getName(), seasonNumber, episodeNumber, episodeTitle, null, null, airdate, id, seriesInfo);
        }).collect(Collectors.toList());
        return new AbstractEpisodeListProvider.SeriesData(seriesInfo, episodes);
    }

    protected Object request(String resource) throws Exception {
        Cache cache = Cache.getCache(this.getName(), CacheType.Monthly);
        return cache.json(resource, s -> this.getResource(resource)).get();
    }

    protected URL getResource(String resource) throws Exception {
        return new URL("http://api.tvmaze.com/" + resource);
    }

    @Override
    public URI getEpisodeListLink(SearchResult searchResult) {
        return URI.create("http://www.tvmaze.com/shows/" + searchResult.getId());
    }
}

