/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.util.RegularExpressions;
import net.filebot.util.StringUtilities;
import net.filebot.util.XPathUtilities;
import net.filebot.web.AbstractEpisodeListProvider;
import net.filebot.web.Artwork;
import net.filebot.web.ArtworkProvider;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeUtilities;
import net.filebot.web.SearchResult;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;
import net.filebot.web.SortOrder;
import net.filebot.web.TheTVDBSeriesInfo;
import net.filebot.web.WebRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TheTVDBClientV1
extends AbstractEpisodeListProvider
implements ArtworkProvider {
    private static final String DEFAULT_MIRROR = "http://thetvdb.com";
    private static final Map<MirrorType, String> mirrors = MirrorType.newMap();
    private String apikey;

    public TheTVDBClientV1(String apikey) {
        this.apikey = apikey;
    }

    @Override
    public String getIdentifier() {
        return "TheTVDB";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.thetvdb");
    }

    @Override
    public boolean hasSeasonSupport() {
        return true;
    }

    public String getLanguageCode(Locale locale) {
        String code;
        switch (code = locale.getLanguage()) {
            case "iw": {
                return "he";
            }
            case "in": {
                return "id";
            }
        }
        return code;
    }

    @Override
    public List<SearchResult> fetchSearchResult(String query, Locale locale) throws Exception {
        Document dom = this.getXmlResource(MirrorType.SEARCH, "GetSeries.php?seriesname=" + WebRequest.encode(query, true) + "&language=" + this.getLanguageCode(locale));
        LinkedHashMap<Integer, SearchResult> resultSet = new LinkedHashMap<Integer, SearchResult>();
        for (Node node : XPathUtilities.selectNodes("Data/Series", dom)) {
            int sid = StringUtilities.matchInteger(XPathUtilities.getTextContent("seriesid", node));
            String seriesName = XPathUtilities.getTextContent("SeriesName", node);
            if (seriesName.startsWith("**") && seriesName.endsWith("**")) {
                Logging.debug.fine(Logging.format("Invalid series: %s [%d]", seriesName, sid));
                continue;
            }
            List<String> aliasNames = XPathUtilities.streamNodes("AliasNames", node).flatMap(it -> RegularExpressions.PIPE.splitAsStream(XPathUtilities.getTextContent(it))).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
            if (resultSet.containsKey(sid)) continue;
            resultSet.put(sid, new SearchResult(sid, seriesName, aliasNames));
        }
        return new ArrayList<SearchResult>(resultSet.values());
    }

    @Override
    protected AbstractEpisodeListProvider.SeriesData fetchSeriesData(SearchResult series, SortOrder sortOrder, Locale locale) throws Exception {
        Document dom = this.getXmlResource(MirrorType.XML, "series/" + series.getId() + "/all/" + this.getLanguageCode(locale) + ".xml");
        Node seriesNode = XPathUtilities.selectNode("Data/Series", dom);
        TheTVDBSeriesInfo seriesInfo = new TheTVDBSeriesInfo(this, locale, series.getId());
        seriesInfo.setOrder(sortOrder.name());
        seriesInfo.setAliasNames(series.getAliasNames());
        seriesInfo.setName(XPathUtilities.getTextContent("SeriesName", seriesNode));
        seriesInfo.setAirsDayOfWeek(XPathUtilities.getTextContent("Airs_DayOfWeek", seriesNode));
        seriesInfo.setAirsTime(XPathUtilities.getTextContent("Airs_Time", seriesNode));
        seriesInfo.setCertification(XPathUtilities.getTextContent("ContentRating", seriesNode));
        seriesInfo.setImdbId(XPathUtilities.getTextContent("IMDB_ID", seriesNode));
        seriesInfo.setNetwork(XPathUtilities.getTextContent("Network", seriesNode));
        seriesInfo.setOverview(XPathUtilities.getTextContent("Overview", seriesNode));
        seriesInfo.setStatus(XPathUtilities.getTextContent("Status", seriesNode));
        seriesInfo.setRating(XPathUtilities.getDecimal(XPathUtilities.getTextContent("Rating", seriesNode)));
        seriesInfo.setRatingCount(StringUtilities.matchInteger(XPathUtilities.getTextContent("RatingCount", seriesNode)));
        seriesInfo.setRuntime(StringUtilities.matchInteger(XPathUtilities.getTextContent("Runtime", seriesNode)));
        seriesInfo.setGenres(XPathUtilities.getListContent("Genre", "\\|", seriesNode));
        seriesInfo.setStartDate(SimpleDate.parse(XPathUtilities.getTextContent("FirstAired", seriesNode)));
        seriesInfo.setBannerUrl(this.getResource(MirrorType.BANNER, XPathUtilities.getTextContent("banner", seriesNode)));
        ArrayList<Episode> episodes = new ArrayList<Episode>(50);
        ArrayList<Episode> specials = new ArrayList<Episode>(5);
        for (Node node : XPathUtilities.selectNodes("Data/Episode", dom)) {
            String episodeName = XPathUtilities.getTextContent("EpisodeName", node);
            Integer absoluteNumber = StringUtilities.matchInteger(XPathUtilities.getTextContent("absolute_number", node));
            SimpleDate airdate = SimpleDate.parse(XPathUtilities.getTextContent("FirstAired", node));
            Integer id = StringUtilities.matchInteger(XPathUtilities.getTextContent("id", node));
            Integer episodeNumber = StringUtilities.matchInteger(XPathUtilities.getTextContent("EpisodeNumber", node));
            Object seasonNumber = StringUtilities.matchInteger(XPathUtilities.getTextContent("SeasonNumber", node));
            if (sortOrder == SortOrder.DVD) {
                String[] dvdSeasonNumber = StringUtilities.matchInteger(XPathUtilities.getTextContent("DVD_season", node));
                Integer dvdEpisodeNumber = StringUtilities.matchInteger(XPathUtilities.getTextContent("DVD_episodenumber", node));
                if (dvdSeasonNumber != null && dvdEpisodeNumber != null) {
                    seasonNumber = dvdSeasonNumber;
                    episodeNumber = dvdEpisodeNumber;
                }
            }
            if (seasonNumber == null || seasonNumber.intValue() == 0) {
                for (String specialSeasonTag : new String[]{"airsafter_season", "airsbefore_season"}) {
                    Integer specialSeason = StringUtilities.matchInteger(XPathUtilities.getTextContent(specialSeasonTag, node));
                    if (specialSeason == null || specialSeason == 0) continue;
                    seasonNumber = specialSeason;
                    break;
                }
                Integer specialNumber = episodeNumber != null ? episodeNumber : EpisodeUtilities.filterBySeason(specials, seasonNumber.intValue()).size() + 1;
                specials.add(new Episode(seriesInfo.getName(), (Integer)seasonNumber, null, episodeName, absoluteNumber, specialNumber, airdate, id, new SeriesInfo(seriesInfo)));
                continue;
            }
            if (sortOrder == SortOrder.Absolute && absoluteNumber != null && absoluteNumber > 0) {
                seasonNumber = null;
                episodeNumber = absoluteNumber;
            } else if (sortOrder == SortOrder.AbsoluteAirdate && airdate != null) {
                seasonNumber = null;
                episodeNumber = airdate.getYear() * 10000 + airdate.getMonth() * 100 + airdate.getDay();
            }
            episodes.add(new Episode(seriesInfo.getName(), (Integer)seasonNumber, episodeNumber, episodeName, absoluteNumber, null, airdate, id, new SeriesInfo(seriesInfo)));
        }
        episodes.sort(EpisodeUtilities.episodeComparator());
        episodes.addAll(specials);
        return new AbstractEpisodeListProvider.SeriesData(seriesInfo, episodes);
    }

    public SearchResult lookupByID(int id, Locale locale) throws Exception {
        if (id <= 0) {
            throw new IllegalArgumentException("Illegal TheTVDB ID: " + id);
        }
        return this.getLookupCache("id", locale).computeIfAbsent(id, it -> {
            Document dom = this.getXmlResource(MirrorType.XML, "series/" + id + "/all/" + this.getLanguageCode(locale) + ".xml");
            String name = XPathUtilities.selectString("//SeriesName", dom);
            return new SearchResult(id, name);
        });
    }

    public SearchResult lookupByIMDbID(int imdbid, Locale locale) throws Exception {
        if (imdbid <= 0) {
            throw new IllegalArgumentException("Illegal IMDbID ID: " + imdbid);
        }
        return this.getLookupCache("imdbid", locale).computeIfAbsent(imdbid, it -> {
            Document dom = this.getXmlResource(MirrorType.SEARCH, "GetSeriesByRemoteID.php?imdbid=" + imdbid + "&language=" + this.getLanguageCode(locale));
            String id = XPathUtilities.selectString("//seriesid", dom);
            String name = XPathUtilities.selectString("//SeriesName", dom);
            if (id.isEmpty() || name.isEmpty()) {
                return null;
            }
            return new SearchResult(Integer.parseInt(id), name);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMirror(MirrorType mirrorType) throws Exception {
        if (mirrorType == MirrorType.NULL) {
            return DEFAULT_MIRROR;
        }
        Map<MirrorType, String> map = mirrors;
        synchronized (map) {
            if (mirrors.isEmpty()) {
                Document dom = this.getXmlResource(MirrorType.NULL, "mirrors.xml");
                Map mirrorLists = XPathUtilities.streamNodes("Mirrors/Mirror", dom).flatMap(node -> {
                    String mirror = XPathUtilities.getTextContent("mirrorpath", node);
                    int typeMask = Integer.parseInt(XPathUtilities.getTextContent("typemask", node));
                    return MirrorType.fromTypeMask(typeMask).stream().collect(Collectors.toMap(m -> m, m -> mirror)).entrySet().stream();
                }).collect(Collectors.groupingBy(Map.Entry::getKey, MirrorType::newMap, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
                Random random = new Random();
                mirrorLists.forEach((type, options) -> {
                    String selection = (String)options.get(random.nextInt(options.size()));
                    mirrors.put((MirrorType)((Object)type), selection);
                });
            }
            return mirrors.getOrDefault((Object)mirrorType, DEFAULT_MIRROR);
        }
    }

    protected Document getXmlResource(MirrorType mirror, String resource) throws Exception {
        Cache cache = Cache.getCache(this.getName(), CacheType.Monthly);
        return cache.xml(resource, s -> this.getResource(mirror, (String)s)).get();
    }

    protected URL getResource(MirrorType mirror, String path) throws Exception {
        StringBuilder url = new StringBuilder(this.getMirror(mirror)).append('/').append(mirror.prefix()).append('/');
        if (mirror.keyRequired()) {
            url.append(this.apikey).append('/');
        }
        return new URL(url.append(path).toString());
    }

    @Override
    public TheTVDBSeriesInfo getSeriesInfo(SearchResult searchResult, Locale language) throws Exception {
        return (TheTVDBSeriesInfo)super.getSeriesInfo(searchResult, language);
    }

    @Override
    public TheTVDBSeriesInfo getSeriesInfo(int id, Locale language) throws Exception {
        return this.getSeriesInfo(new SearchResult(id), language);
    }

    public TheTVDBSeriesInfo getSeriesInfoByIMDbID(int imdbid, Locale locale) throws Exception {
        return this.getSeriesInfo(this.lookupByIMDbID(imdbid, locale), locale);
    }

    @Override
    public URI getEpisodeListLink(SearchResult searchResult) {
        return URI.create("http://www.thetvdb.com/?tab=seasonall&id=" + searchResult.getId());
    }

    @Override
    public List<Artwork> getArtwork(int id, String category, Locale locale) throws Exception {
        Document dom = this.getXmlResource(MirrorType.XML, "series/" + id + "/banners.xml");
        URL mirror = this.getResource(MirrorType.BANNER, "");
        return XPathUtilities.streamNodes("//Banner", dom).map(node -> {
            try {
                String type = XPathUtilities.getTextContent("BannerType", node);
                String subKey = XPathUtilities.getTextContent("BannerType2", node);
                String fileName = XPathUtilities.getTextContent("BannerPath", node);
                String season = XPathUtilities.getTextContent("Season", node);
                String language = XPathUtilities.getTextContent("Language", node);
                Double rating = XPathUtilities.getDecimal(XPathUtilities.getTextContent("Rating", node));
                return new Artwork(Stream.of(type, subKey, season), new URL(mirror, fileName), language == null ? null : new Locale(language), rating);
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e, e::getMessage);
                return null;
            }
        }).filter(Objects::nonNull).filter(it -> it.getTags().contains(category)).collect(Collectors.toList());
    }

    protected Cache.TypedCache<SearchResult> getLookupCache(String type, Locale language) {
        return Cache.getCache(this.getName() + "_lookup_" + type + "_" + language, CacheType.Monthly).cast(SearchResult.class);
    }

    protected static enum MirrorType {
        NULL(0),
        SEARCH(1),
        XML(1),
        BANNER(2);

        final int bitMask;

        private MirrorType(int bitMask) {
            this.bitMask = bitMask;
        }

        public String prefix() {
            return this != BANNER ? "api" : "banners";
        }

        public boolean keyRequired() {
            return this != BANNER && this != SEARCH;
        }

        public static EnumSet<MirrorType> fromTypeMask(int mask) {
            return EnumSet.of(SEARCH, XML, BANNER).stream().filter(m -> (mask & m.bitMask) != 0).collect(Collectors.toCollection(MirrorType::newSet));
        }

        public static EnumSet<MirrorType> newSet() {
            return EnumSet.noneOf(MirrorType.class);
        }

        public static <T> EnumMap<MirrorType, T> newMap() {
            return new EnumMap(MirrorType.class);
        }
    }
}

