/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.tools.ant.BuildException;

public class IvyArtifactProperty
extends IvyPostResolveTask {
    private String name;
    private String value;
    private boolean overwrite = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        try {
            ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
            String[] confs = this.splitConfs(this.getConf());
            String resolveId = this.getResolveId();
            if (resolveId == null) {
                resolveId = ResolveOptions.getDefaultResolveId(this.getResolvedModuleId());
            }
            XmlReportParser parser = new XmlReportParser();
            for (int i = 0; i < confs.length; ++i) {
                File report = cacheMgr.getConfigurationResolveReportInCache(resolveId, confs[i]);
                parser.parse(report);
                Artifact[] artifacts = parser.getArtifacts();
                for (int j = 0; j < artifacts.length; ++j) {
                    Artifact artifact = artifacts[j];
                    String name = IvyPatternHelper.substitute(this.getSettings().substitute(this.getName()), artifact, confs[i]);
                    String value = IvyPatternHelper.substitute(this.getSettings().substitute(this.getValue()), artifact, confs[i]);
                    this.setProperty(name, value);
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException("impossible to add artifact properties: " + ex, ex);
        }
    }

    private void setProperty(String name, String value) {
        if (this.overwrite) {
            this.getProject().setProperty(name, value);
        } else {
            this.getProject().setNewProperty(name, value);
        }
    }
}

