/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.ssh.LogListener;

public abstract class AbstractSshMessage {
    private static final double ONE_SECOND = 1000.0;
    private final Session session;
    private final boolean verbose;
    private final boolean compressed;
    private LogListener listener = new LogListener(){

        @Override
        public void log(String message) {
        }
    };
    private ProgressMonitor monitor = null;

    public AbstractSshMessage(Session session) {
        this(false, session);
    }

    public AbstractSshMessage(boolean verbose, Session session) {
        this(verbose, false, session);
    }

    public AbstractSshMessage(boolean verbose, boolean compressed, Session session) {
        this.verbose = verbose;
        this.compressed = compressed;
        this.session = session;
    }

    protected Channel openExecChannel(String command) throws JSchException {
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        channel.setCommand(command);
        return channel;
    }

    protected ChannelSftp openSftpChannel() throws JSchException {
        ChannelSftp channel = (ChannelSftp)this.session.openChannel("sftp");
        return channel;
    }

    protected void sendAck(OutputStream out) throws IOException {
        byte[] buf = new byte[]{0};
        out.write(buf);
        out.flush();
    }

    protected void waitForAck(InputStream in) throws IOException, BuildException {
        int b = in.read();
        if (b == -1) {
            throw new BuildException("No response from server");
        }
        if (b != 0) {
            StringBuffer sb = new StringBuffer();
            int c = in.read();
            while (c > 0 && c != 10) {
                sb.append((char)c);
                c = in.read();
            }
            if (b == 1) {
                throw new BuildException("server indicated an error: " + sb.toString());
            }
            if (b == 2) {
                throw new BuildException("server indicated a fatal error: " + sb.toString());
            }
            throw new BuildException("unknown response, code " + b + " message: " + sb.toString());
        }
    }

    public abstract void execute() throws IOException, JSchException;

    public void setLogListener(LogListener aListener) {
        this.listener = aListener;
    }

    protected void log(String message) {
        this.listener.log(message);
    }

    protected void logStats(long timeStarted, long timeEnded, long totalLength) {
        double duration = (double)(timeEnded - timeStarted) / 1000.0;
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(1);
        this.listener.log("File transfer time: " + format.format(duration) + " Average Rate: " + format.format((double)totalLength / duration) + " B/s");
    }

    protected final boolean getVerbose() {
        return this.verbose;
    }

    protected final boolean getCompressed() {
        return this.compressed;
    }

    protected final int trackProgress(long filesize, long totalLength, int percentTransmitted) {
        int percent = (int)Math.round(Math.floor((double)totalLength / (double)filesize * 100.0));
        if (percent > percentTransmitted) {
            if (filesize < 0x100000L) {
                if (percent % 10 == 0) {
                    if (percent == 100) {
                        System.out.println(" 100%");
                    } else {
                        System.out.print("*");
                    }
                }
            } else if (percent == 50) {
                System.out.println(" 50%");
            } else if (percent == 100) {
                System.out.println(" 100%");
            } else {
                System.out.print(".");
            }
        }
        return percent;
    }

    protected SftpProgressMonitor getProgressMonitor() {
        if (this.monitor == null) {
            this.monitor = new ProgressMonitor();
        }
        return this.monitor;
    }

    private class ProgressMonitor
    implements SftpProgressMonitor {
        private long initFileSize = 0L;
        private long totalLength = 0L;
        private int percentTransmitted = 0;

        private ProgressMonitor() {
        }

        @Override
        public void init(int op, String src, String dest, long max) {
            this.initFileSize = max;
            this.totalLength = 0L;
            this.percentTransmitted = 0;
        }

        @Override
        public boolean count(long len) {
            this.totalLength += len;
            this.percentTransmitted = AbstractSshMessage.this.trackProgress(this.initFileSize, this.totalLength, this.percentTransmitted);
            return true;
        }

        @Override
        public void end() {
        }

        public long getTotalLength() {
            return this.totalLength;
        }
    }
}

