/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redstone.xmlrpc.XmlRpcDispatcher;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcInvocationHandler;
import redstone.xmlrpc.XmlRpcInvocationInterceptor;
import redstone.xmlrpc.XmlRpcSerializer;
import redstone.xmlrpc.handlers.ReflectiveInvocationHandler;

public class XmlRpcServer {
    private Map handlers = new HashMap();
    private List interceptors = new ArrayList();
    private XmlRpcSerializer serializer;

    public XmlRpcServer() {
        this.serializer = new XmlRpcSerializer();
    }

    public XmlRpcServer(XmlRpcSerializer xmlRpcSerializer) {
        this.serializer = xmlRpcSerializer;
    }

    public void execute(InputStream inputStream, Writer writer) throws XmlRpcException {
        XmlRpcDispatcher xmlRpcDispatcher = new XmlRpcDispatcher(this, "(unknown)");
        xmlRpcDispatcher.dispatch(inputStream, writer);
    }

    public void addInvocationHandler(String string, Object object) {
        this.addInvocationHandler(string, new ReflectiveInvocationHandler(object));
    }

    public void addInvocationHandler(String string, XmlRpcInvocationHandler xmlRpcInvocationHandler) {
        if (string == null) {
            string = XmlRpcDispatcher.DEFAULT_HANDLER_NAME;
        }
        this.handlers.put(string, xmlRpcInvocationHandler);
    }

    public XmlRpcInvocationHandler getInvocationHandler(String string) {
        return (XmlRpcInvocationHandler)this.handlers.get(string);
    }

    public void removeInvocationHandler(String string) {
        this.handlers.remove(string);
    }

    public void addInvocationInterceptor(XmlRpcInvocationInterceptor xmlRpcInvocationInterceptor) {
        this.interceptors.add(xmlRpcInvocationInterceptor);
    }

    public List getInvocationInterceptors() {
        return this.interceptors;
    }

    public void removeInvocationInterceptor(XmlRpcInvocationInterceptor xmlRpcInvocationInterceptor) {
        this.interceptors.remove(xmlRpcInvocationInterceptor);
    }

    public XmlRpcSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(XmlRpcSerializer xmlRpcSerializer) {
        this.serializer = xmlRpcSerializer;
    }
}

